#ifndef _AACTION_H_
#define _AACTION_H_
/* Copyright 1995 Carnegie Mellon University All rights reserved.
  $Disclaimer: Andrew User Interface System - Binary Distribution 7.5
 * 
 * Permission to use, copy, modify, and distribute this software for any 
 * purpose is hereby granted, provided (a) that no fee is charged for the 
 * software, for the medium on which it is distributed, for the 
 * distribution process, or for effort involved in making the distribution;  
 * (b) that all copyright notices, this permission notice, and the 
 * following disclaimer remain in these files and appear in supporting 
 * documentation;  (c) that you do not translate, reverse engineer, 
 * decompile, or disassemble the software; and (d) that the names of 
 * IBM, Carnegie Mellon University, and other copyright holders not 
 * be used in advertising or publicity pertaining to distribution of the 
 * software.
 * 
 * CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
 * COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
 * WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
 * UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
 * OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
  */

#include <andrewos.h>
#include <avalue.H>

static atom_def aaction_error("error");;

class aaction : public ATK {
  public:
    virtual ATKregistryEntry *ATKregistry();
    // The function call operator invokes the action on the given object, passing the arguments in in.
    // and returning any result in out.
    virtual void operator()(ATK *obj, const avalueflex &in, avalueflex &out);
    // ArgTypes() returns an avalueflex representing the argument types.
    // The elements of the returned avalueflex are:  (all are of type atom)
    // index	name	value
    // 0		none	1st argument type
    // etc...
    // last	positional	none	lastpositional argument type
    // any		name	any named argument type
    // etc...
    // If the avalueflex is empty then any arguments will be accepted.
    // (They may however be ignored.)
    // In addition named arguments not in the list may still be passed.
    virtual avalueflex &ArgTypes();
           // RetTypes() returns an avalueflex representing the return types.
    // The elements of the returned avalueflex are:  (all are of type atom)
    // index	name	value
    // 0		none	1st return value type
    // etc...
    // last	positional	none	lastpositional return value type
    // any		name	any named return value type
    // etc...
    // Named arguments not listed may be present in an actual return value.
    // if the avalueflex is empty any arguments may be returned.
    virtual avalueflex &RetTypes();

    virtual ~aaction();
};

#define AACTION_DUMMY_CLASS class

#define DEFINE_AACTION_FUNC_CLASS(name,type) \
AACTION_DUMMY_CLASS name : public aaction { \
	void (*func)(type *o, const avalueflex &aux, const avalueflex &in, avalueflex &out); \
	avalueflex auxargs; \
	avalueflex intypes, outtypes; \
  public: \
	inline name(void (*p)(type *o, const avalueflex &aux,  const avalueflex &in, avalueflex &out), const avalueflex &a) : func(p), auxargs(a) { \
    	} \
	inline name(void (*p)(type *o, const avalueflex &aux,  const avalueflex &in, avalueflex &out), const avalueflex &a, const avalueflex &t, const avalueflex &r) : func(p), auxargs(a), intypes(t), outtypes(r) { \
    	} \
	inline virtual void operator()(ATK *obj, const avalueflex &in, avalueflex &out) { \
		func(((type *)obj), auxargs, in, out); \
	} \
	inline virtual avalueflex &ArgTypes() { \
		return intypes; \
	} \
	inline virtual avalueflex &RetTypes() { \
		return outtypes; \
	} \
};

#define DEFINE_AACTION_CLASS(name,type) \
AACTION_DUMMY_CLASS name : public aaction { \
	void (type::*pmf)(const avalueflex &aux,  const avalueflex &in, avalueflex &out); \
	avalueflex auxargs; \
	avalueflex intypes, outtypes; \
  public: \
	inline name(void (type::*p)(const avalueflex &aux,  const avalueflex &in, avalueflex &out), const avalueflex &a) : pmf(p), auxargs(a) { \
    	} \
	inline name(void (type::*p)(const avalueflex &aux,  const avalueflex &in, avalueflex &out), const avalueflex &a, const avalueflex &t,  constavalueflex &r) : pmf(p), auxargs(a), intypes(t), outtypes(r) { \
    	} \
	inline virtual void operator()(ATK *obj, const avalueflex &in, avalueflex &out) { \
 		void (type::*p)(const avalueflex &in, const avalueflex &aux, avalueflex &out)=pmf;  \
		(((type *)obj)->*p)(auxargs, in, out); \
	} \
	inline virtual avalueflex &ArgTypes() { \
		return intypes; \
	} \
	inline virtual avalueflex &RetTypes() { \
		return outtypes; \
	} \
};
#endif

