ATK_INTER
#ifndef _ATK_H
#define _ATK_H
/* 
 *	Copyright IBM Corporation 1988,1991 - All Rights Reserved      
 *	Copyright Carnegie Mellon University 1992-1996 - All Rights Reserved
 *	For full copyright information see: 'config/COPYRITE'
 */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/

#define THROWONFAILURE(x) do { if(!(x)) ATKConstructorFailure(); return; } while (0)
#ifndef boolean /* if somebody wants to use a macro for boolean, let them. */
typedef int boolean;
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

typedef boolean (*ATKinitfptr)();
/*
 * Use the ATKdefineRegistry macro to enter a class into the runtime
 * registry.  It expands to a variable declaration and should probably
 * appear immediately after the include files in a class' implementation.
 * It's use looks like this (example):
 *
 *    ATKdefineRegistry(textview, view, initfunc);
 *
 * For multiple inheritance, ATKdefineRegistry2(class, supclass1, supclass2)
 * can be defined, and so on.  We will defer defining these until
 * someone actually askes for them.  In any case, the extra classes
 * must themselves be subclasses of ATK, otherwise the runtime system
 * is not interested in them, and they may be safely omitted.
 *
 *    ATKdefineRegistryNoInit(textview, view);
 *
 * Should be used when no class initialization is required or
 * you will be providing your own initialization mechanism.
 */
#define ATKdefineRegistry(me,sup, initf) \
  static ATK *me ## _new_() { return new me; };\
  extern ATKregistryEntry sup ## _ATKregistry_;\
  ATKregistryEntry me ## _ATKregistry_ = \
      {#me, me ## _new_, initf, {&sup ## _ATKregistry_ }};\
ATKregistryEntry *me ## ::ATKregistry() { return &me ## _ATKregistry_; }\
static ATKinitfptr *ATKinited_= &(me ## _ATKregistry_.initfunc);

#define ATKdefineRegistryNoInit(me, sup) \
  static ATK *me ## _new_() { return new me; };\
  extern ATKregistryEntry sup ## _ATKregistry_;\
  ATKregistryEntry me ## _ATKregistry_ = \
{#me, me ## _new_, NULL, {&sup ## _ATKregistry_ }};\
ATKregistryEntry *me ## ::ATKregistry() { return &me ## _ATKregistry_; }

/*
 * Use the ATKregister macro to register a class.
 * It will automatically register this class and all superclasses
 * of this class.  It generates executable code.  Use it as follows:
 *
 *     ATKregister(textview);
 */
#define ATKregister(classname) \
  extern ATKregistryEntry classname ## _ATKregistry_;\
  ATK::RegisterClass(&classname ## _ATKregistry_);

/*
 * Use the ATKinit macro at the start of each constructor,
 * and at the start of each classprocedure implementation.
 * It checks if the class has been initialized, and if not
 * calls the function InitializeClass.
 *
 * If an implementation spans many files, the programmer must
 * code the initialization explicitly.  
 */
#define ATKinit {if (ATKinited_ && *ATKinited_) {boolean (*initfunc)()=(*ATKinited_); (*ATKinited_)=NULL; ATKinited_=NULL; initfunc();  }}

/*
 * The atk class is the root of entire atk class heirarchy.
 * Only subclasses of atk may be registered with the runtime
 * system.
 */
#define ATKmaxRegistryParents 1
class ATK;

struct ATKregistryEntry {
    const char *ClassName;
    // A function which will create a new object of the class.
      ATK *(*New)();
    // A function to be called when the first static member
    // function, or constructor is called.  (All static
    // member functions and constructors should
    // begin with ATKinit;)				     
    ATKinitfptr initfunc;    
    // The parents of this class, so far we only support
    // single inheritance in the run-time system.
    ATKregistryEntry *parents[ATKmaxRegistryParents];
    // The next ATKregistryEntry in the list of loaded
    // classes.
    ATKregistryEntry *next;
    // Returns the name of the class.
    inline const char *GetTypeName() { return ClassName; }
    // Analogs of the IsType methods listed below for ATK.
    const boolean IsType(const ATKregistryEntry *typeobject);
    const boolean IsType(const char *classname);
    const boolean IsType(const ATK *typeobject);
};


class ATK {
  public:
    // Runtime registry information for this class.
    // This function is generally not used by ATK users.  The
    // ATKregister macro expands to a call to this function.
    static void RegisterClass(ATKregistryEntry *classent);

    // All subclasses of ATK must provide their own registry entry.
    // The ATKregister macro defines this member function, but the ATK
    // programmer must nonetheless declare it in his class.
    virtual ATKregistryEntry *ATKregistry();

    // Support for looking up an ATKregistryEntry by name,
    // and dynamically loading a class.
    static ATKregistryEntry *DynamicLoad(const char *classname, boolean trace=FALSE);
    static int &DynamicLoadTrace();	/* non-zero writes msgs to stdout */
    
    static ATKregistryEntry *LoadClass(const char *classname);
    // Returns TRUE iff the named class is already loaded.
    static boolean IsLoaded(const char *classname);
    
    
    // IsType returns true if "this" is a subclass of the given
    // registry, classname or other ATK object.
    inline const boolean IsType(const ATKregistryEntry *classent) {
	return ATKregistry()->IsType(classent);
    }
    inline const boolean IsType(const char *classname) {
	return ATKregistry()->IsType(classname);
    }
    inline const boolean IsType(const ATK *typeobject) {
	return ATKregistry()->IsType(typeobject);
    }

    // Create a new object of the same type as this object.
    // You will need to cast the return value to the appropriate
    // type.
    inline ATK *NewFromObject() {
	return ATKregistry()->New();
    }
    
    
    // IsTypeByName returns true if sub is a subclass of super.
    static const boolean IsTypeByName(const char *sub, const char *super);

    // GetTypeName returns a string representing the classname
    // of any given ATK object.
    inline const char *GetTypeName() { return ATKregistry()->ClassName; };

    // The NewObject function can create an instance of any ATK class
    // that has been registered with the ATK runtime system (with ATKregister).
    static ATK *NewObject(const char *classname);

    // Called by the THROWONFAILURE macro when a constructor fails.
    // This can be overridden to print a different message.
    // Note that it CANNOT access virtual functions of the class.
    // Also, it cannot be virtual.  Calling virtual functions in
    // a constructor results in one of the base class versions
    // of the function being called.
    static void ATKConstructorFailure();
};

#endif /* _ATK_H */
