/*
 * Copyright (c) 2000 University of Southern California 
 *
 * Permission  is hereby  granted,  free  of  charge, to  any  person
 * obtaining a  copy of  this software  and  associated documentation
 * files   (the  "Software"),  to   deal  in  the   Software  without
 * restriction, including without  limitation the rights to use, copy,
 * modify, merge, publish,  distribute, sublicense, and/or sell copies
 * of  the Software,  and to  permit persons to  whom the  Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above  copyright notice  and this  permission notice  shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED "AS IS",  WITHOUT WARRANTY OF  ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING  BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY,   FITNESS   FOR   A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM,  DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF  CONTRACT, TORT OR OTHERWISE, ARISING FROM,  OUT OF OR IN
 * CONNECTION  WITH THE SOFTWARE OR  THE USE OR OTHER  DEALINGS IN THE
 * SOFTWARE.  
 */

/*
 *  Corner Turn
 *
 *  By Jinwoo Suh  (University of  Southern California  - Information
 *  Sciences Institute (jsuh@isi.edu)
 *  Nov. 8th, 2000
 *
 *  This  code performs corner turn  operation. The source  data is in
 *  src  array and  the source  data is transposed  and stored  in dst
 *  array. The transposition is  performed block by block and the size
 *  of  the block is 'block'  x 'block'. The  use of the block  is for
 *  maximizing the  use of cache.  The size  of the destination matrix
 *  is 'rows' by 'cols'.
 *
 */

/* Modified by: Rodric M. Rabbah 06-03-04 */

#include <stdio.h>

#define SIZE 1024

int rows, cols, block;
int src[SIZE*SIZE];
int dst[SIZE*SIZE];


main(int argc, char* argv[])
{
  int i;
  FILE* file;

  if (argc != 5) {
    printf("Usage: %s <inputFile> <outputFile> <size> <block>\n", argv[0]);
    exit(1);
  }

  rows  = cols = atoi(argv[3]);
  block = atoi(argv[4]);

  if (((unsigned) rows > 1024) | ((unsigned) block > (unsigned) rows)) {
    printf("size must be in [0, 1024]; block must be <= than size\n");
    exit(1);
  }

  //read the input into the input array from a file
  file = fopen(argv[1], "r");
  fread(src, SIZE*SIZE, sizeof(int), file);
  fclose(file);

  /*** VERSABENCH START ***/

  {
    int stage, i, j, k, m;
    volatile data;
    int *dest_addr, *src_addr;

    for (i = 0; i < cols; i += block) {
	for (j = 0; j < rows; j += block) {
	  dest_addr = dst + j * cols+i;
	  src_addr  = src + i * rows+j;

	  for (k = i;  k < i+block; k++) {
	    for (m = j; m < j+block; m++) {
		*dest_addr  = *src_addr;
		 dest_addr += cols;
		 src_addr++;
	    }

	    dest_addr -= (cols * block - 1);
	    src_addr  += (rows - block);
	  }
	}
    }
  }

  /*** VERSABENCH END ***/
  
  //write the output to a file
  file = fopen(argv[2], "w");
  fwrite(dst, SIZE*SIZE, sizeof(int), file);
  fclose(file);
}
