/* mgrid.f -- translated by f2c (version 20000121).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    doublereal u[2530944], v[2197000], r__[2530944], a[4], c__[4];
    integer ir[7], mm[7];
} x_;

#define x_1 x_

/* Table of constant values */

static integer c__3 = 3;
static integer c__1 = 1;
static integer c__5 = 5;
static integer c__4 = 4;
static integer c__2 = 2;
static integer c_b22 = 2197000;
static integer c_b23 = 2530944;
static integer c__0 = 0;
static doublereal c_b40 = 0.;
static integer c__9 = 9;

/* Main program */ int main()
{
    /* Format strings */
    static char fmt_9004[] = "(4d8.0)";
    static char fmt_7[] = "(/,\002 KERNEL B:  SOLVING A POISSON PROBLEM ON\
 A \002,i6,\002 BY \002,i6,\002 BY \002,i6,\002 GRID,\002,/,\002 USING \002,\
i6,\002 MULTIGRID ITERATIONS.\002,/)";
    static char fmt_6[] = "(i4,2e19.12)";

    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Builtin functions */
    integer s_rsle(), do_lio(), e_rsle(), s_rsfe(), do_fio(), e_rsfe(), 
	    pow_ii(), s_wsfe(), e_wsfe();
    /* Subroutine */ int s_stop();

    /* Local variables */
    static doublereal oldu, rnmu;
    extern /* Subroutine */ int zran3_(), zero3_();
    static integer i__, n;
    extern /* Subroutine */ int resid_();
    static integer mtime;
    extern /* Subroutine */ int setup_();
    static doublereal u0;
    static integer it;
    static doublereal xx;
    static integer ntimes;
    extern /* Subroutine */ int norm2u3_();
    static integer lmi, nit;
    static doublereal old2;
    extern /* Subroutine */ int mg3p_();
    static doublereal rnm2;

    /* Fortran I/O blocks */
    static cilist io___1 = { 0, 5, 0, 0, 0 };
    static cilist io___3 = { 0, 5, 0, 0, 0 };
    static cilist io___5 = { 0, 5, 0, 0, 0 };
    static cilist io___7 = { 0, 5, 0, 0, 0 };
    static cilist io___9 = { 0, 5, 0, fmt_9004, 0 };
    static cilist io___10 = { 0, 5, 0, fmt_9004, 0 };
    static cilist io___13 = { 0, 6, 0, fmt_7, 0 };
    static cilist io___21 = { 0, 6, 0, "(A40)", 0 };
    static cilist io___22 = { 0, 6, 0, "(A40)", 0 };
    static cilist io___23 = { 0, 6, 0, fmt_6, 0 };
    static cilist io___24 = { 0, 6, 0, fmt_6, 0 };



/* CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC */

/*        'MGXDEMO' DEMONSTRATES THE CAPABILITIES OF A VERY SIMPLE MULTIGRID */
/*        SOLVER IN COMPUTING A THREE DIMENSIONAL POTENTIAL FIELD.  THIS IS */
/*        A SIMPLIFIED MULTIGRID SOLVER IN TWO IMPORTANT RESPECTS: */

/*                (1) IT SOLVES ONLY A CONSTANT COEFFICIENT EQUATION, */
/*                AND THAT ONLY ON A UNIFORM CUBICAL GRID, */

/*                (2) IT SOLVES ONLY A SINGLE EQUATION, REPRESENTING */
/*                A SCALAR FIELD RATHER THAN A VECTOR FIELD. */

/*        WE CHOSE IT FOR ITS PORTABILITY AND SIMPLICITY, AND EXPECT THAT A */
/*        SUPERCOMPUTER WHICH CAN RUN IT EFFECTIVELY WILL ALSO BE ABLE TO */
/*        RUN MORE COMPLEX MULTIGRID PROGRAMS AT LEAST AS WELL. */

/*              ERIC BARSZCZ                        PAUL FREDERICKSON */
/*                                                      RIACS */
/*        NASA AMES RESEARCH CENTER            NASA AMES RESEARCH CENTER */

/* CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC */

/*      PARAMETER( NIT=40 ) */

	/*** VERSABENCH START ***/

    s_rsle(&io___1);
    do_lio(&c__3, &c__1, (char *)&lmi, (ftnlen)sizeof(integer));
    e_rsle();
    s_rsle(&io___3);
    do_lio(&c__3, &c__1, (char *)&nit, (ftnlen)sizeof(integer));
    e_rsle();
    s_rsle(&io___5);
    do_lio(&c__3, &c__1, (char *)&ntimes, (ftnlen)sizeof(integer));
    e_rsle();
    s_rsle(&io___7);
    do_lio(&c__5, &c__1, (char *)&u0, (ftnlen)sizeof(doublereal));
    e_rsle();
    s_rsfe(&io___9);
    do_fio(&c__4, (char *)&x_1.a[0], (ftnlen)sizeof(doublereal));
    e_rsfe();
    s_rsfe(&io___10);
    do_fio(&c__4, (char *)&x_1.c__[0], (ftnlen)sizeof(doublereal));
    e_rsfe();
    for (i__ = 0; i__ <= 3; ++i__) {
	x_1.a[i__] /= 3.;
	x_1.c__[i__] /= 64.;
    }

    n = pow_ii(&c__2, &lmi) + 2;
    s_wsfe(&io___13);
    i__1 = n - 2;
    do_fio(&c__1, (char *)&i__1, (ftnlen)sizeof(integer));
    i__2 = n - 2;
    do_fio(&c__1, (char *)&i__2, (ftnlen)sizeof(integer));
    i__3 = n - 2;
    do_fio(&c__1, (char *)&i__3, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&nit, (ftnlen)sizeof(integer));
    e_wsfe();

    setup_(&lmi, x_1.ir, x_1.mm);
    xx = 314159265.;
    i__1 = ntimes;
    for (mtime = 1; mtime <= i__1; ++mtime) {
	zero3_(x_1.u, &u0, &n, &n, &n);
	zran3_(&xx, x_1.v, &n, &n, &n);
	resid_(x_1.u, x_1.v, x_1.r__, &n, x_1.a);
	norm2u3_(x_1.r__, &n, &n, &n, &rnm2, &rnmu, &n, &n, &n);
	old2 = rnm2;
	oldu = rnmu;

	i__2 = nit;
	for (it = 1; it <= i__2; ++it) {
	    mg3p_(x_1.u, x_1.v, x_1.r__, &n, x_1.a, x_1.c__, &c_b22, &c_b23, 
		    x_1.ir, x_1.mm, &lmi);
	    resid_(x_1.u, x_1.v, x_1.r__, &n, x_1.a);
/* L20: */
	}


	norm2u3_(x_1.r__, &n, &n, &n, &rnm2, &rnmu, &n, &n, &n);
	s_wsfe(&io___21);
	e_wsfe();
	s_wsfe(&io___22);
	do_fio(&c__1, " IT    L2-NORM(R)         UNIF-NORM(R)", (ftnlen)38);
	e_wsfe();
	s_wsfe(&io___23);
	do_fio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&old2, (ftnlen)sizeof(doublereal));
	do_fio(&c__1, (char *)&oldu, (ftnlen)sizeof(doublereal));
	e_wsfe();
	s_wsfe(&io___24);
	do_fio(&c__1, (char *)&nit, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&rnm2, (ftnlen)sizeof(doublereal));
	do_fio(&c__1, (char *)&rnmu, (ftnlen)sizeof(doublereal));
	e_wsfe();
/* L1000: */
    }


    s_stop("", (ftnlen)0);
	/*** VERSABENCH END ***/
} /* MAIN__ */


/* *****  MG3P   IMPLEMENTS A SIMPLE, CONSTANT COEFFICIENT VERSION OF THE */
/* *****        MG ALGORITHM FAPIN (FAST APPROXIMATE INVERSE) */

/* Subroutine */ int mg3p_(u, v, r__, n, a, c__, nv, nr, ir, mm, lm)
doublereal *u, *v, *r__;
integer *n;
doublereal *a, *c__;
integer *nv, *nr, *ir, *mm, *lm;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    extern /* Subroutine */ int rprj3_(), zero3_();
    static integer j, k;
    extern /* Subroutine */ int resid_(), psinv_(), interp_();




    /* Parameter adjustments */
    --v;
    --r__;
    --u;
    --mm;
    --ir;

    /* Function Body */
    for (k = *lm; k >= 2; --k) {
	j = k - 1;
	rprj3_(&r__[ir[k]], &mm[k], &r__[ir[j]], &mm[j]);
/* L50: */
    }

    k = 1;
    zero3_(&u[ir[k]], &c_b40, &mm[k], &mm[k], &mm[k]);
    psinv_(&r__[ir[k]], &u[ir[k]], &mm[k], c__);
    if (*lm == 2) {
	goto L200;
    }
    i__1 = *lm - 1;
    for (k = 2; k <= i__1; ++k) {
	j = k - 1;
	zero3_(&u[ir[k]], &c_b40, &mm[k], &mm[k], &mm[k]);
	interp_(&u[ir[j]], &mm[j], &u[ir[k]], &mm[k]);
	resid_(&u[ir[k]], &r__[ir[k]], &r__[ir[k]], &mm[k], a);
	psinv_(&r__[ir[k]], &u[ir[k]], &mm[k], c__);
/* L100: */
    }
L200:
    j = *lm - 1;
    k = *lm;
    interp_(&u[ir[j]], &mm[j], &u[1], n);
    resid_(&u[1], &v[1], &r__[1], n, a);
    psinv_(&r__[1], &u[1], n, c__);

    return 0;
} /* mg3p_ */


/* ***** PSINV APPLIES AN APPROXIMATE INVERSE AS SMOOTHER:  U = U + CR */

/*      THIS SIMPLE IMPLEMENTATION COSTS  27A + 4M PER RESULT, WHERE */
/*      A AND M DENOTE THE COSTS OF ADDITION AND MULTIPLICATION. */
/*      BY USING SEVERAL TWO-DIMENSIONAL BUFFERS ONE CAN REDUCE THIS */
/*      COST TO  13A + 4M IN THE GENERAL CASE, OR  11A + 3M WHEN THE */
/*      COEFFICIENT C(3) IS ZERO. */

/* Subroutine */ int psinv_(r__, u, n, c__)
doublereal *r__, *u;
integer *n;
doublereal *c__;
{
    /* Format strings */
    static char fmt_9000[] = "(1x,e15.6)";

    /* System generated locals */
    integer u_dim1, u_dim2, u_offset, r_dim1, r_dim2, r_offset, i__1, i__2, 
	    i__3;

    /* Builtin functions */
    integer s_wsfe(), do_fio(), e_wsfe();

    /* Local variables */
    extern /* Subroutine */ int comm3_();
    static integer i1, i2, i3;

    /* Fortran I/O blocks */
    static cilist io___30 = { 0, 6, 0, fmt_9000, 0 };



    /* Parameter adjustments */
    u_dim1 = *n;
    u_dim2 = *n;
    u_offset = 1 + u_dim1 * (1 + u_dim2 * 1);
    u -= u_offset;
    r_dim1 = *n;
    r_dim2 = *n;
    r_offset = 1 + r_dim1 * (1 + r_dim2 * 1);
    r__ -= r_offset;

    /* Function Body */
    i__1 = *n - 1;
    for (i3 = 2; i3 <= i__1; ++i3) {
	i__2 = *n - 1;
	for (i2 = 2; i2 <= i__2; ++i2) {
	    i__3 = *n - 1;
	    for (i1 = 2; i1 <= i__3; ++i1) {
/* L600: */
		u[i1 + (i2 + i3 * u_dim2) * u_dim1] = u[i1 + (i2 + i3 * 
			u_dim2) * u_dim1] + c__[0] * r__[i1 + (i2 + i3 * 
			r_dim2) * r_dim1] + c__[1] * (r__[i1 - 1 + (i2 + i3 * 
			r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + i3 * r_dim2) * 
			r_dim1] + r__[i1 + (i2 - 1 + i3 * r_dim2) * r_dim1] + 
			r__[i1 + (i2 + 1 + i3 * r_dim2) * r_dim1] + r__[i1 + (
			i2 + (i3 - 1) * r_dim2) * r_dim1] + r__[i1 + (i2 + (
			i3 + 1) * r_dim2) * r_dim1]) + c__[2] * (r__[i1 - 1 + 
			(i2 - 1 + i3 * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 - 
			1 + i3 * r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + 1 + 
			i3 * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + 1 + i3 * 
			r_dim2) * r_dim1] + r__[i1 + (i2 - 1 + (i3 - 1) * 
			r_dim2) * r_dim1] + r__[i1 + (i2 + 1 + (i3 - 1) * 
			r_dim2) * r_dim1] + r__[i1 + (i2 - 1 + (i3 + 1) * 
			r_dim2) * r_dim1] + r__[i1 + (i2 + 1 + (i3 + 1) * 
			r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + (i3 - 1) * 
			r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + (i3 + 1) * 
			r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + (i3 - 1) * 
			r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + (i3 + 1) * 
			r_dim2) * r_dim1]) + c__[3] * (r__[i1 - 1 + (i2 - 1 + 
			(i3 - 1) * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 - 1 + 
			(i3 - 1) * r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + 1 + 
			(i3 - 1) * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + 1 + 
			(i3 - 1) * r_dim2) * r_dim1] + r__[i1 - 1 + (i2 - 1 + 
			(i3 + 1) * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 - 1 + 
			(i3 + 1) * r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + 1 + 
			(i3 + 1) * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + 1 + 
			(i3 + 1) * r_dim2) * r_dim1]);
	    }
	}
    }

    comm3_(&u[u_offset], n);
    s_wsfe(&io___30);
    i__3 = *n;
    for (i3 = 1; i3 <= i__3; i3 += 69) {
	i__2 = *n;
	for (i2 = 1; i2 <= i__2; i2 += 69) {
	    i__1 = *n;
	    for (i1 = 1; i1 <= i__1; i1 += 69) {
		do_fio(&c__1, (char *)&u[i1 + (i2 + i3 * u_dim2) * u_dim1], (
			ftnlen)sizeof(doublereal));
	    }
	}
    }
    e_wsfe();

    return 0;
} /* psinv_ */


/* ****** RESID COMPUTES THE RESIDUAL:  R = V - AU */

/*      THIS SIMPLE IMPLEMENTATION COSTS  27A + 4M PER RESULT, WHERE */
/*      A AND M DENOTE THE COSTS OF ADDITION (OR SUBTRACTION) AND */
/*      MULTIPLICATION, RESPECTIVELY.  BY USING SEVERAL TWO-DIMENSIONAL */
/*      BUFFERS ONE CAN REDUCE THIS COST TO  13A + 4M IN THE GENERAL */
/*      CASE, OR  10A + 3M WHEN THE COEFFICIENT A(1) IS ZERO. */

/* Subroutine */ int resid_(u, v, r__, n, a)
doublereal *u, *v, *r__;
integer *n;
doublereal *a;
{
    /* Format strings */
    static char fmt_9010[] = "(1x,e15.6)";

    /* System generated locals */
    integer u_dim1, u_dim2, u_offset, v_dim1, v_dim2, v_offset, r_dim1, 
	    r_dim2, r_offset, i__1, i__2, i__3;

    /* Builtin functions */
    integer s_wsfe(), do_fio(), e_wsfe();

    /* Local variables */
    extern /* Subroutine */ int comm3_();
    static integer i1, i2, i3;

    /* Fortran I/O blocks */
    static cilist io___34 = { 0, 6, 0, fmt_9010, 0 };



    /* Parameter adjustments */
    r_dim1 = *n;
    r_dim2 = *n;
    r_offset = 1 + r_dim1 * (1 + r_dim2 * 1);
    r__ -= r_offset;
    v_dim1 = *n;
    v_dim2 = *n;
    v_offset = 1 + v_dim1 * (1 + v_dim2 * 1);
    v -= v_offset;
    u_dim1 = *n;
    u_dim2 = *n;
    u_offset = 1 + u_dim1 * (1 + u_dim2 * 1);
    u -= u_offset;

    /* Function Body */
    i__1 = *n - 1;
    for (i3 = 2; i3 <= i__1; ++i3) {
	i__2 = *n - 1;
	for (i2 = 2; i2 <= i__2; ++i2) {
	    i__3 = *n - 1;
	    for (i1 = 2; i1 <= i__3; ++i1) {
/* L600: */
		r__[i1 + (i2 + i3 * r_dim2) * r_dim1] = v[i1 + (i2 + i3 * 
			v_dim2) * v_dim1] - a[0] * u[i1 + (i2 + i3 * u_dim2) *
			 u_dim1] - a[1] * (u[i1 - 1 + (i2 + i3 * u_dim2) * 
			u_dim1] + u[i1 + 1 + (i2 + i3 * u_dim2) * u_dim1] + u[
			i1 + (i2 - 1 + i3 * u_dim2) * u_dim1] + u[i1 + (i2 + 
			1 + i3 * u_dim2) * u_dim1] + u[i1 + (i2 + (i3 - 1) * 
			u_dim2) * u_dim1] + u[i1 + (i2 + (i3 + 1) * u_dim2) * 
			u_dim1]) - a[2] * (u[i1 - 1 + (i2 - 1 + i3 * u_dim2) *
			 u_dim1] + u[i1 + 1 + (i2 - 1 + i3 * u_dim2) * u_dim1]
			 + u[i1 - 1 + (i2 + 1 + i3 * u_dim2) * u_dim1] + u[i1 
			+ 1 + (i2 + 1 + i3 * u_dim2) * u_dim1] + u[i1 + (i2 - 
			1 + (i3 - 1) * u_dim2) * u_dim1] + u[i1 + (i2 + 1 + (
			i3 - 1) * u_dim2) * u_dim1] + u[i1 + (i2 - 1 + (i3 + 
			1) * u_dim2) * u_dim1] + u[i1 + (i2 + 1 + (i3 + 1) * 
			u_dim2) * u_dim1] + u[i1 - 1 + (i2 + (i3 - 1) * 
			u_dim2) * u_dim1] + u[i1 - 1 + (i2 + (i3 + 1) * 
			u_dim2) * u_dim1] + u[i1 + 1 + (i2 + (i3 - 1) * 
			u_dim2) * u_dim1] + u[i1 + 1 + (i2 + (i3 + 1) * 
			u_dim2) * u_dim1]) - a[3] * (u[i1 - 1 + (i2 - 1 + (i3 
			- 1) * u_dim2) * u_dim1] + u[i1 + 1 + (i2 - 1 + (i3 - 
			1) * u_dim2) * u_dim1] + u[i1 - 1 + (i2 + 1 + (i3 - 1)
			 * u_dim2) * u_dim1] + u[i1 + 1 + (i2 + 1 + (i3 - 1) *
			 u_dim2) * u_dim1] + u[i1 - 1 + (i2 - 1 + (i3 + 1) * 
			u_dim2) * u_dim1] + u[i1 + 1 + (i2 - 1 + (i3 + 1) * 
			u_dim2) * u_dim1] + u[i1 - 1 + (i2 + 1 + (i3 + 1) * 
			u_dim2) * u_dim1] + u[i1 + 1 + (i2 + 1 + (i3 + 1) * 
			u_dim2) * u_dim1]);
	    }
	}
    }

    comm3_(&r__[r_offset], n);
    s_wsfe(&io___34);
    i__3 = *n;
    for (i3 = 1; i3 <= i__3; i3 += 69) {
	i__2 = *n;
	for (i2 = 1; i2 <= i__2; i2 += 69) {
	    i__1 = *n;
	    for (i1 = 1; i1 <= i__1; i1 += 69) {
		do_fio(&c__1, (char *)&u[i1 + (i2 + i3 * u_dim2) * u_dim1], (
			ftnlen)sizeof(doublereal));
	    }
	}
    }
    e_wsfe();

    return 0;
} /* resid_ */


/* ***** RPRJ3 PROJECTS ONTO THE NEXT COARSER GRID, */
/* ***** USING A TRILINEAR FINITE ELEMENT PROJECTION:  S = R' = P R */

/*      THIS SIMPLE IMPLEMENTATION COSTS  27A + 4M PER RESULT, WHERE */
/*      A AND M DENOTE THE COSTS OF ADDITION AND MULTIPLICATION. */
/*      BY USING SEVERAL TWO-DIMENSIONAL BUFFERS ONE CAN REDUCE THIS */
/*      COST TO  23A + 1M.  (NOTE, HOWEVER, THAT THE NUMBER OF RESULTS */
/*      IS ABOUT 1/8 THAT OF THE OTHER THREE OPERATORS.) */

/* Subroutine */ int rprj3_(r__, mk, s, mj)
doublereal *r__;
integer *mk;
doublereal *s;
integer *mj;
{
    /* System generated locals */
    integer r_dim1, r_dim2, r_offset, s_dim1, s_dim2, s_offset, i__1, i__2, 
	    i__3;

    /* Local variables */
    extern /* Subroutine */ int comm3_();
    static integer i1, j1, j2, j3, i3, i2;


    /* Parameter adjustments */
    r_dim1 = *mk;
    r_dim2 = *mk;
    r_offset = 1 + r_dim1 * (1 + r_dim2 * 1);
    r__ -= r_offset;
    s_dim1 = *mj;
    s_dim2 = *mj;
    s_offset = 1 + s_dim1 * (1 + s_dim2 * 1);
    s -= s_offset;

    /* Function Body */
    i__1 = *mj - 1;
    for (j3 = 2; j3 <= i__1; ++j3) {
	i3 = (j3 << 1) - 1;
	i__2 = *mj - 1;
	for (j2 = 2; j2 <= i__2; ++j2) {
	    i2 = (j2 << 1) - 1;
	    i__3 = *mj - 1;
	    for (j1 = 2; j1 <= i__3; ++j1) {
		i1 = (j1 << 1) - 1;
/* L100: */
		s[j1 + (j2 + j3 * s_dim2) * s_dim1] = r__[i1 + (i2 + i3 * 
			r_dim2) * r_dim1] * .5 + (r__[i1 - 1 + (i2 + i3 * 
			r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + i3 * r_dim2) * 
			r_dim1] + r__[i1 + (i2 - 1 + i3 * r_dim2) * r_dim1] + 
			r__[i1 + (i2 + 1 + i3 * r_dim2) * r_dim1] + r__[i1 + (
			i2 + (i3 - 1) * r_dim2) * r_dim1] + r__[i1 + (i2 + (
			i3 + 1) * r_dim2) * r_dim1]) * .25 + (r__[i1 - 1 + (
			i2 - 1 + i3 * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 - 
			1 + i3 * r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + 1 + 
			i3 * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + 1 + i3 * 
			r_dim2) * r_dim1] + r__[i1 + (i2 - 1 + (i3 - 1) * 
			r_dim2) * r_dim1] + r__[i1 + (i2 + 1 + (i3 - 1) * 
			r_dim2) * r_dim1] + r__[i1 + (i2 - 1 + (i3 + 1) * 
			r_dim2) * r_dim1] + r__[i1 + (i2 + 1 + (i3 + 1) * 
			r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + (i3 - 1) * 
			r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + (i3 + 1) * 
			r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + (i3 - 1) * 
			r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + (i3 + 1) * 
			r_dim2) * r_dim1]) * .125 + (r__[i1 - 1 + (i2 - 1 + (
			i3 - 1) * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 - 1 + (
			i3 - 1) * r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + 1 + (
			i3 - 1) * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + 1 + (
			i3 - 1) * r_dim2) * r_dim1] + r__[i1 - 1 + (i2 - 1 + (
			i3 + 1) * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 - 1 + (
			i3 + 1) * r_dim2) * r_dim1] + r__[i1 - 1 + (i2 + 1 + (
			i3 + 1) * r_dim2) * r_dim1] + r__[i1 + 1 + (i2 + 1 + (
			i3 + 1) * r_dim2) * r_dim1]) * .0625;
	    }
	}
    }

    comm3_(&s[s_offset], mj);

    return 0;
} /* rprj3_ */


/* ***** INTERP ADDS THE TRILINEAR INTERPOLATION OF THE CORRECTION */
/* ***** FROM THE COARSER GRID TO THE CURRENT APPROXIMATION:  U = U + QU' */

/*      THIS SIMPLE IMPLEMENTATION COSTS  (27/8)A + (7/8)M PER RESULT, */
/*      WHERE A AND M DENOTE THE COSTS OF ADDITION AND MULTIPLICATION. */
/*      BY USING SEVERAL TWO-DIMENSIONAL BUFFERS ONE CAN REDUCE THIS */
/*      COST TO  (15/8)A + (7/8)M. */

/* Subroutine */ int interp_(z__, m, u, n)
doublereal *z__;
integer *m;
doublereal *u;
integer *n;
{
    /* System generated locals */
    integer z_dim1, z_dim2, z_offset, u_dim1, u_dim2, u_offset, i__1, i__2, 
	    i__3;

    /* Local variables */
    extern /* Subroutine */ int comm3_();
    static integer i1, i2, i3;


    /* Parameter adjustments */
    z_dim1 = *m;
    z_dim2 = *m;
    z_offset = 1 + z_dim1 * (1 + z_dim2 * 1);
    z__ -= z_offset;
    u_dim1 = *n;
    u_dim2 = *n;
    u_offset = 1 + u_dim1 * (1 + u_dim2 * 1);
    u -= u_offset;

    /* Function Body */
    i__1 = *m - 1;
    for (i3 = 2; i3 <= i__1; ++i3) {
	i__2 = *m - 1;
	for (i2 = 2; i2 <= i__2; ++i2) {
	    i__3 = *m - 1;
	    for (i1 = 2; i1 <= i__3; ++i1) {
		u[(i1 << 1) - 1 + ((i2 << 1) - 1 + ((i3 << 1) - 1) * u_dim2) *
			 u_dim1] += z__[i1 + (i2 + i3 * z_dim2) * z_dim1];
/* L100: */
	    }
	    i__3 = *m - 1;
	    for (i1 = 2; i1 <= i__3; ++i1) {
		u[(i1 << 1) - 2 + ((i2 << 1) - 1 + ((i3 << 1) - 1) * u_dim2) *
			 u_dim1] += (z__[i1 - 1 + (i2 + i3 * z_dim2) * z_dim1]
			 + z__[i1 + (i2 + i3 * z_dim2) * z_dim1]) * .5;
/* L200: */
	    }
	}
	i__3 = *m - 1;
	for (i2 = 2; i2 <= i__3; ++i2) {
	    i__2 = *m - 1;
	    for (i1 = 2; i1 <= i__2; ++i1) {
		u[(i1 << 1) - 1 + ((i2 << 1) - 2 + ((i3 << 1) - 1) * u_dim2) *
			 u_dim1] += (z__[i1 + (i2 - 1 + i3 * z_dim2) * z_dim1]
			 + z__[i1 + (i2 + i3 * z_dim2) * z_dim1]) * .5;
/* L300: */
	    }
	    i__2 = *m - 1;
	    for (i1 = 2; i1 <= i__2; ++i1) {
		u[(i1 << 1) - 2 + ((i2 << 1) - 2 + ((i3 << 1) - 1) * u_dim2) *
			 u_dim1] += (z__[i1 - 1 + (i2 - 1 + i3 * z_dim2) * 
			z_dim1] + z__[i1 - 1 + (i2 + i3 * z_dim2) * z_dim1] + 
			z__[i1 + (i2 - 1 + i3 * z_dim2) * z_dim1] + z__[i1 + (
			i2 + i3 * z_dim2) * z_dim1]) * .25;
/* L400: */
	    }
	}
    }

    i__2 = *m - 1;
    for (i3 = 2; i3 <= i__2; ++i3) {
	i__3 = *m - 1;
	for (i2 = 2; i2 <= i__3; ++i2) {
	    i__1 = *m - 1;
	    for (i1 = 2; i1 <= i__1; ++i1) {
		u[(i1 << 1) - 1 + ((i2 << 1) - 1 + ((i3 << 1) - 2) * u_dim2) *
			 u_dim1] += (z__[i1 + (i2 + (i3 - 1) * z_dim2) * 
			z_dim1] + z__[i1 + (i2 + i3 * z_dim2) * z_dim1]) * .5;
/* L500: */
	    }
	    i__1 = *m - 1;
	    for (i1 = 2; i1 <= i__1; ++i1) {
		u[(i1 << 1) - 2 + ((i2 << 1) - 1 + ((i3 << 1) - 2) * u_dim2) *
			 u_dim1] += (z__[i1 - 1 + (i2 + (i3 - 1) * z_dim2) * 
			z_dim1] + z__[i1 + (i2 + (i3 - 1) * z_dim2) * z_dim1] 
			+ z__[i1 - 1 + (i2 + i3 * z_dim2) * z_dim1] + z__[i1 
			+ (i2 + i3 * z_dim2) * z_dim1]) * .25;
/* L600: */
	    }
	}
	i__1 = *m - 1;
	for (i2 = 2; i2 <= i__1; ++i2) {
	    i__3 = *m - 1;
	    for (i1 = 2; i1 <= i__3; ++i1) {
		u[(i1 << 1) - 1 + ((i2 << 1) - 2 + ((i3 << 1) - 2) * u_dim2) *
			 u_dim1] += (z__[i1 + (i2 - 1 + (i3 - 1) * z_dim2) * 
			z_dim1] + z__[i1 + (i2 + (i3 - 1) * z_dim2) * z_dim1] 
			+ z__[i1 + (i2 - 1 + i3 * z_dim2) * z_dim1] + z__[i1 
			+ (i2 + i3 * z_dim2) * z_dim1]) * .25;
/* L700: */
	    }
	    i__3 = *m - 1;
	    for (i1 = 2; i1 <= i__3; ++i1) {
		u[(i1 << 1) - 2 + ((i2 << 1) - 2 + ((i3 << 1) - 2) * u_dim2) *
			 u_dim1] += (z__[i1 - 1 + (i2 - 1 + (i3 - 1) * z_dim2)
			 * z_dim1] + z__[i1 - 1 + (i2 + (i3 - 1) * z_dim2) * 
			z_dim1] + z__[i1 + (i2 - 1 + (i3 - 1) * z_dim2) * 
			z_dim1] + z__[i1 + (i2 + (i3 - 1) * z_dim2) * z_dim1] 
			+ z__[i1 - 1 + (i2 - 1 + i3 * z_dim2) * z_dim1] + z__[
			i1 - 1 + (i2 + i3 * z_dim2) * z_dim1] + z__[i1 + (i2 
			- 1 + i3 * z_dim2) * z_dim1] + z__[i1 + (i2 + i3 * 
			z_dim2) * z_dim1]) * .125;
/* L800: */
	    }
	}
    }

    comm3_(&u[u_offset], n);

    return 0;
} /* interp_ */


/* ***** COMM3 COMMUNICATES ON ALL BORDERS OF AN ARRAY */

/* Subroutine */ int comm3_(u, n)
doublereal *u;
integer *n;
{
    /* System generated locals */
    integer u_dim1, u_dim2, u_offset, i__1, i__2;

    /* Local variables */
    static integer i1, i2, i3;


    /* Parameter adjustments */
    u_dim1 = *n;
    u_dim2 = *n;
    u_offset = 1 + u_dim1 * (1 + u_dim2 * 1);
    u -= u_offset;

    /* Function Body */
    i__1 = *n - 1;
    for (i3 = 2; i3 <= i__1; ++i3) {
	i__2 = *n - 1;
	for (i2 = 2; i2 <= i__2; ++i2) {
	    u[(i2 + i3 * u_dim2) * u_dim1 + 1] = u[*n - 1 + (i2 + i3 * u_dim2)
		     * u_dim1];
	    u[*n + (i2 + i3 * u_dim2) * u_dim1] = u[(i2 + i3 * u_dim2) * 
		    u_dim1 + 2];
/* L100: */
	}
    }

    i__2 = *n - 1;
    for (i3 = 2; i3 <= i__2; ++i3) {
	i__1 = *n;
	for (i1 = 1; i1 <= i__1; ++i1) {
	    u[i1 + (i3 * u_dim2 + 1) * u_dim1] = u[i1 + (*n - 1 + i3 * u_dim2)
		     * u_dim1];
	    u[i1 + (*n + i3 * u_dim2) * u_dim1] = u[i1 + (i3 * u_dim2 + 2) * 
		    u_dim1];
/* L200: */
	}
    }
    i__1 = *n;
    for (i2 = 1; i2 <= i__1; ++i2) {
	i__2 = *n;
	for (i1 = 1; i1 <= i__2; ++i1) {
	    u[i1 + (i2 + u_dim2) * u_dim1] = u[i1 + (i2 + (*n - 1) * u_dim2) *
		     u_dim1];
	    u[i1 + (i2 + *n * u_dim2) * u_dim1] = u[i1 + (i2 + (u_dim2 << 1)) 
		    * u_dim1];
/* L300: */
	}
    }

    return 0;
} /* comm3_ */


/* ***** NORM2U3 EVALUATES APPROXIMATIONS TO THE L2 NORM AND THE */
/* ***** UNIFORM (OR L-INFINITY OR CHEBYSHEV) NORM, UNDER THE */
/* ***** ASSUMPTION THAT THE BOUNDARIES ARE PERIODIC OR ZERO.  ADD THE */
/* ***** BOUNDARIES IN WITH HALF WEIGHT (QUARTER WEIGHT ON THE EDGES */
/* ***** AND EIGTH WEIGHT AT THE CORNERS) FOR INHOMOGENEOUS BOUNDARIES. */

/* Subroutine */ int norm2u3_(r__, n1, n2, n3, rnm2, rnmu, nx, ny, nz)
doublereal *r__;
integer *n1, *n2, *n3;
doublereal *rnm2, *rnmu;
integer *nx, *ny, *nz;
{
    /* System generated locals */
    integer r_dim1, r_dim2, r_offset, i__1, i__2, i__3;
    doublereal d__1;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static doublereal a, s;
    static integer i1, i2, i3;


    /* Parameter adjustments */
    r_dim1 = *n1;
    r_dim2 = *n2;
    r_offset = 1 + r_dim1 * (1 + r_dim2 * 1);
    r__ -= r_offset;

    /* Function Body */
    s = 0.;
    *rnmu = 0.;
    i__1 = *n3 - 1;
    for (i3 = 2; i3 <= i__1; ++i3) {
	i__2 = *n2 - 1;
	for (i2 = 2; i2 <= i__2; ++i2) {
	    i__3 = *n1 - 1;
	    for (i1 = 2; i1 <= i__3; ++i1) {
/* Computing 2nd power */
		d__1 = r__[i1 + (i2 + i3 * r_dim2) * r_dim1];
		s += d__1 * d__1;
		a = (d__1 = r__[i1 + (i2 + i3 * r_dim2) * r_dim1], abs(d__1));
		if (a > *rnmu) {
		    *rnmu = a;
		}
/* L100: */
	    }
	}
    }
    *rnm2 = sqrt(s / (real) ((*nx - 2) * (*ny - 2) * (*nz - 2)));

    return 0;
} /* norm2u3_ */


/* ***** SETUP   MUST BE CALLED BEFORE MG3P */

/* Subroutine */ int setup_(lm, ir, mm)
integer *lm, *ir, *mm;
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer pow_ii();

    /* Local variables */
    static integer k, l;


    /* Parameter adjustments */
    --mm;
    --ir;

    /* Function Body */
    mm[*lm] = pow_ii(&c__2, lm) + 2;
    for (k = *lm - 1; k >= 1; --k) {
	mm[k] = mm[k + 1] / 2 + 1;
/* L100: */
    }
    l = *lm;

    ir[l] = 1;
    for (k = l - 1; k >= 1; --k) {
/* Computing 3rd power */
	i__1 = mm[k + 1];
	ir[k] = ir[k + 1] + i__1 * (i__1 * i__1);
/* L200: */
    }

    return 0;
} /* setup_ */


/* ** */

/* Subroutine */ int zero3_(z__, u0, nx, ny, nz)
doublereal *z__, *u0;
integer *nx, *ny, *nz;
{
    /* System generated locals */
    integer z_dim1, z_dim2, z_offset, i__1, i__2, i__3;

    /* Local variables */
    static integer i1, i2, i3;


    /* Parameter adjustments */
    z_dim1 = *nx;
    z_dim2 = *ny;
    z_offset = 1 + z_dim1 * (1 + z_dim2 * 1);
    z__ -= z_offset;

    /* Function Body */
    i__1 = *nz;
    for (i3 = 1; i3 <= i__1; ++i3) {
	i__2 = *ny;
	for (i2 = 1; i2 <= i__2; ++i2) {
	    i__3 = *nx;
	    for (i1 = 1; i1 <= i__3; ++i1) {
/* L100: */
		z__[i1 + (i2 + i3 * z_dim2) * z_dim1] = *u0;
	    }
	}
    }

    return 0;
} /* zero3_ */


/* ***** ZRAN3  LOADS +1 AT TEN RANDOMLY CHOSEN POINTS, */
/* *****        LOADS -1 AT A DIFFERENT TEN RANDOM POINTS, */
/* *****        AND ZERO ELSEWHERE. */

/* Subroutine */ int zran3_(x, z__, n1, n2, n3)
doublereal *x, *z__;
integer *n1, *n2, *n3;
{
    /* Format strings */
    static char fmt_9007[] = "(5(2x,i3,2(1x,i3),1x))";
    static char fmt_7[] = "(5(\002 (\002,i3,2(\002,\002,i3),\002)\002))";

    /* System generated locals */
    integer z_dim1, z_dim2, z_offset, i__1, i__2, i__3;

    /* Builtin functions */
    integer s_rsle(), e_rsle(), s_rsfe(), do_fio(), e_rsfe(), s_wsle(), 
	    do_lio(), e_wsle(), s_wsfe(), e_wsfe();

    /* Local variables */
    extern /* Subroutine */ int comm3_();
    static integer i__, i1, i2, i3, j1[20]	/* was [10][2] */, j2[20]	
	    /* was [10][2] */, j3[20]	/* was [10][2] */;

    /* Fortran I/O blocks */
    static cilist io___57 = { 0, 5, 0, 0, 0 };
    static cilist io___58 = { 0, 5, 0, fmt_9007, 0 };
    static cilist io___63 = { 0, 5, 0, 0, 0 };
    static cilist io___64 = { 0, 5, 0, fmt_9007, 0 };
    static cilist io___65 = { 0, 6, 0, 0, 0 };
    static cilist io___66 = { 0, 6, 0, fmt_7, 0 };
    static cilist io___67 = { 0, 6, 0, 0, 0 };
    static cilist io___68 = { 0, 6, 0, fmt_7, 0 };




    /* Parameter adjustments */
    z_dim1 = *n1;
    z_dim2 = *n2;
    z_offset = 1 + z_dim1 * (1 + z_dim2 * 1);
    z__ -= z_offset;

    /* Function Body */
    s_rsle(&io___57);
    e_rsle();
    s_rsfe(&io___58);
    for (i__ = 1; i__ <= 10; ++i__) {
	do_fio(&c__1, (char *)&j1[i__ - 1], (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&j2[i__ - 1], (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&j3[i__ - 1], (ftnlen)sizeof(integer));
    }
    e_rsfe();
    s_rsle(&io___63);
    e_rsle();
    s_rsfe(&io___64);
    for (i__ = 1; i__ <= 10; ++i__) {
	do_fio(&c__1, (char *)&j1[i__ + 9], (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&j2[i__ + 9], (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&j3[i__ + 9], (ftnlen)sizeof(integer));
    }
    e_rsfe();

    s_wsle(&io___65);
    do_lio(&c__9, &c__1, " NEGATIVE CHARGES AT", (ftnlen)20);
    e_wsle();
    s_wsfe(&io___66);
    for (i__ = 1; i__ <= 10; ++i__) {
	do_fio(&c__1, (char *)&j1[i__ - 1], (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&j2[i__ - 1], (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&j3[i__ - 1], (ftnlen)sizeof(integer));
    }
    e_wsfe();
    s_wsle(&io___67);
    do_lio(&c__9, &c__1, " POSITIVE CHARGES AT", (ftnlen)20);
    e_wsle();
    s_wsfe(&io___68);
    for (i__ = 1; i__ <= 10; ++i__) {
	do_fio(&c__1, (char *)&j1[i__ + 9], (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&j2[i__ + 9], (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&j3[i__ + 9], (ftnlen)sizeof(integer));
    }
    e_wsfe();

    i__1 = *n3;
    for (i3 = 1; i3 <= i__1; ++i3) {
	i__2 = *n2;
	for (i2 = 1; i2 <= i__2; ++i2) {
	    i__3 = *n1;
	    for (i1 = 1; i1 <= i__3; ++i1) {
		z__[i1 + (i2 + i3 * z_dim2) * z_dim1] = 0.;
/* L400: */
	    }
	}
    }

    for (i__ = 1; i__ <= 10; ++i__) {
	z__[j1[i__ - 1] + (j2[i__ - 1] + j3[i__ - 1] * z_dim2) * z_dim1] = 
		-1.;
	z__[j1[i__ + 9] + (j2[i__ + 9] + j3[i__ + 9] * z_dim2) * z_dim1] = 1.;
/* L500: */
    }

    comm3_(&z__[z_offset], n1);

    return 0;
} /* zran3_ */


/* **** BUBBLE	DOES A BUBBLE SORT IN DIRECTION DIR */

/* Subroutine */ int bubble_(ten, j1, j2, j3, m, ind)
doublereal *ten;
integer *j1, *j2, *j3, *m, *ind;
{
    /* System generated locals */
    integer ten_dim1, ten_offset, j1_dim1, j1_offset, j2_dim1, j2_offset, 
	    j3_dim1, j3_offset, i__1;

    /* Local variables */
    static doublereal temp;
    static integer i__, jxtemp;
    static doublereal dir;


    /* Parameter adjustments */
    j3_dim1 = *m;
    j3_offset = 1 + j3_dim1 * 0;
    j3 -= j3_offset;
    j2_dim1 = *m;
    j2_offset = 1 + j2_dim1 * 0;
    j2 -= j2_offset;
    j1_dim1 = *m;
    j1_offset = 1 + j1_dim1 * 0;
    j1 -= j1_offset;
    ten_dim1 = *m;
    ten_offset = 1 + ten_dim1 * 0;
    ten -= ten_offset;

    /* Function Body */
    if (*ind == 1) {
	dir = 1.;
    } else {
	dir = -1.;
    }

    i__1 = *m - 1;
    for (i__ = 1; i__ <= i__1; ++i__) {
	if (dir * ten[i__ + *ind * ten_dim1] > dir * ten[i__ + 1 + *ind * 
		ten_dim1]) {
	    temp = ten[i__ + 1 + *ind * ten_dim1];
	    ten[i__ + 1 + *ind * ten_dim1] = ten[i__ + *ind * ten_dim1];
	    ten[i__ + *ind * ten_dim1] = temp;

	    jxtemp = j1[i__ + 1 + *ind * j1_dim1];
	    j1[i__ + 1 + *ind * j1_dim1] = j1[i__ + *ind * j1_dim1];
	    j1[i__ + *ind * j1_dim1] = jxtemp;

	    jxtemp = j2[i__ + 1 + *ind * j2_dim1];
	    j2[i__ + 1 + *ind * j2_dim1] = j2[i__ + *ind * j2_dim1];
	    j2[i__ + *ind * j2_dim1] = jxtemp;

	    jxtemp = j3[i__ + 1 + *ind * j3_dim1];
	    j3[i__ + 1 + *ind * j3_dim1] = j3[i__ + *ind * j3_dim1];
	    j3[i__ + *ind * j3_dim1] = jxtemp;

	} else {
	    return 0;
	}

/* L100: */
    }

    return 0;
} /* bubble_ */
