/*
 * Copyright (c) 2002 David Wentzlaff
 *
 * Permission  is hereby  granted,  free  of  charge, to  any  person
 * obtaining a  copy of  this software  and  associated documentation
 * files   (the  "Software"),  to   deal  in  the   Software  without
 * restriction, including without  limitation the rights to use, copy,
 * modify, merge, publish,  distribute, sublicense, and/or sell copies
 * of  the Software,  and to  permit persons to  whom the  Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above  copyright notice  and this  permission notice  shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED "AS IS",  WITHOUT WARRANTY OF  ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING  BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY,   FITNESS   FOR   A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM,  DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF  CONTRACT, TORT OR OTHERWISE, ARISING FROM,  OUT OF OR IN
 * CONNECTION  WITH THE SOFTWARE OR  THE USE OR OTHER  DEALINGS IN THE
 * SOFTWARE.  
 */

//This is part of David Wentzlaff's Masters Thesis
//This file is Copyright David Wentzlaff 2002 All Rights Reserved.
//
// Filename : testbench.c
// Date : 07/09/2002

/* Modified by: Rodric M. Rabbah 06-03-04 */

#include <stdio.h>
#include <stdlib.h>
#include "calc.h"
#include "testbench.h"

unsigned long runTestbench(int numberOfBits, char* inputFileName, char* outputFileName0, char* outputFileName1)
{
	unsigned int * theBigAllocatedThing;
	unsigned int * theInputArray;
	unsigned int * theOutputArray0;
	unsigned int * theOutputArray1;
	unsigned int * theShiftRegister;
	FILE * inputFile;
	FILE * outputFile0;
	FILE * outputFile1;
	unsigned int readData;

	unsigned long theTicks;
 	unsigned int bits0;
	unsigned int bits1;
	int counter;
	int counter2;

	theTicks = 0;

	theBigAllocatedThing = (unsigned int *) malloc((numberOfBits * sizeof(unsigned int) * 3) + sizeof(unsigned int));
	theInputArray = theBigAllocatedThing;
	theOutputArray0 = theBigAllocatedThing + numberOfBits;
	theOutputArray1 = theBigAllocatedThing + (2 * numberOfBits);
	theShiftRegister = theBigAllocatedThing + (3 * numberOfBits);
	*theShiftRegister = 0;

	//read the input into the input array from a file
	inputFile = fopen(inputFileName, "r");
	fread(theInputArray, numberOfBits, sizeof(unsigned int), inputFile);
	fclose(inputFile);

	/*** VERSABENCH START ***/

	//run calc for numberOfBits times
	for(counter = 0; counter < numberOfBits; counter++) {
	  calc(theInputArray[counter],  theShiftRegister, theOutputArray0 + counter, theOutputArray1 + counter);
	}

	/*** VERSABENCH END ***/
	
	//printf("The meat of the computation took %16ld cycles\n", theTicks);
	//printf("Each iteration took <= %16ld cycles\n", (theTicks/numberOfBits)+1);
  	//dump the outputs to a files
	outputFile0 = fopen(outputFileName0, "w");
	outputFile1 = fopen(outputFileName1, "w");
	for(counter = 0; counter < (numberOfBits/32); counter++) {
	  bits0 = 0;
	  bits1 = 0;
	  for(counter2 = 0; counter2 < 32; counter2++) {
	    bits0 = (bits0 << 1) | theOutputArray0[(counter * 32) + counter2];
	    bits1 = (bits1 << 1) | theOutputArray1[(counter * 32) + counter2];
	  }
	  fprintf(outputFile0, "%8.8X\n", bits0);
	  fprintf(outputFile1, "%8.8X\n", bits1);
	}
	fclose(outputFile0);
	fclose(outputFile1);

	free(theBigAllocatedThing);
	return theTicks;
}

#if 0	
	for(counter = 0; counter < (numberOfBits/32); counter++)
	{
		fscanf(inputFile, "%X\n", &readData);
		for(counter2 = 0; counter2 < 32; counter2++)
		{
			theInputArray[(counter * 32) + counter2] = (readData >> counter2) & 1;
		}
	}

	//touch both of the output arrays so that they are in the L2
	for(counter = 0; counter < numberOfBits; counter ++)
	{
		theOutputArray0[counter] = counter;
		theOutputArray1[counter] = counter;
	}
#endif


#if 0
	for(counter = 0; counter < numberOfBits / 16; counter += 16)
	{
		calc(theInputArray[counter+0],  theShiftRegister, theOutputArray0 + counter+0, theOutputArray1 + counter+0);
		calc(theInputArray[counter+1],  theShiftRegister, theOutputArray0 + counter+1, theOutputArray1 + counter+1);
		calc(theInputArray[counter+2],  theShiftRegister, theOutputArray0 + counter+2, theOutputArray1 + counter+2);
		calc(theInputArray[counter+3],  theShiftRegister, theOutputArray0 + counter+3, theOutputArray1 + counter+3);

		calc(theInputArray[counter+4],  theShiftRegister, theOutputArray0 + counter+4, theOutputArray1 + counter+4);
		calc(theInputArray[counter+5],  theShiftRegister, theOutputArray0 + counter+5, theOutputArray1 + counter+5);
		calc(theInputArray[counter+6],  theShiftRegister, theOutputArray0 + counter+6, theOutputArray1 + counter+6);
		calc(theInputArray[counter+7],  theShiftRegister, theOutputArray0 + counter+7, theOutputArray1 + counter+7);

		calc(theInputArray[counter+8],  theShiftRegister, theOutputArray0 + counter+8, theOutputArray1 + counter+8);
		calc(theInputArray[counter+9],  theShiftRegister, theOutputArray0 + counter+9, theOutputArray1 + counter+9);
		calc(theInputArray[counter+10], theShiftRegister, theOutputArray0 + counter+10, theOutputArray1 + counter+10);
		calc(theInputArray[counter+11], theShiftRegister, theOutputArray0 + counter+11, theOutputArray1 + counter+11);

		calc(theInputArray[counter+12], theShiftRegister, theOutputArray0 + counter+12, theOutputArray1 + counter+12);
		calc(theInputArray[counter+13], theShiftRegister, theOutputArray0 + counter+13, theOutputArray1 + counter+13);
		calc(theInputArray[counter+14], theShiftRegister, theOutputArray0 + counter+14, theOutputArray1 + counter+14);
		calc(theInputArray[counter+15], theShiftRegister, theOutputArray0 + counter+15, theOutputArray1 + counter+15);
	}
#endif
