#include <stdio.h>
#include <string.h>

#define STDIN stdin

#define TRUE 1
#define FALSE 0
typedef unsigned boolean;

#define MAX_PKTS 200
#define MAX_PKT_LEN 500


FILE *fin;

/* This is how many packets there are */
unsigned num_pkts;

/* This is a 2D array of packets, the first dimension
 * is the packet number, and the second
 * dimension is the byte in the packet (starting at byte0). 
 * eg: pkt[2][5] is the second packet, sixth byte */
unsigned char pkt[MAX_PKTS][MAX_PKT_LEN];

/* This is the length of each packet
* eg: pkt_len[1] is the length of the packet 1 */
unsigned pkt_length[MAX_PKTS];


/* This reads in the packets from a text file and stores them in 
 * the above arrays */
void read_pkts(){
  char linebuf[1024];
  char hex[128];
  char *tmp_buf;
  unsigned char num;
  int pkt_num;
  int i = 0;
  int pkt_idx = 0;

  while (fgets(linebuf,1024,fin)){
    tmp_buf = strtok(linebuf," \t");

    pkt_num = (int)atoi(tmp_buf);

    if (pkt_idx >= MAX_PKTS){
      fprintf(stderr,"Read too many packets %d, %d\n",pkt_idx,MAX_PKTS);
      exit (1);
    }

    i = 0;
    while (tmp_buf = strtok(NULL," \t")){
      sprintf(hex,"0x%s",tmp_buf);
      num = (unsigned char)strtoul(hex,NULL,0);

      if (i >= MAX_PKT_LEN){
	fprintf(stderr,"Read too many packet bytes\n");
	exit (1);
      }

      pkt[pkt_idx][i] = num;
      i++;
    }
    pkt_length[pkt_idx] = i;

    pkt[pkt_idx][i] = 0; /* this is to terminate the 'string' */
    pkt_idx++;
  }
  num_pkts = pkt_idx;
}

void
main(int argc, char **argv){
  char *fname;

  if (argc != 2){
    fprintf(stderr,"  usage: %s <tcp_trace_filename>\n",argv[0]);
    exit(1);
  }

  fname = argv[1];

  fin = fopen(fname,"r");
  if (!fin){
    fprintf(stderr,"  error opening file '%s'\n",fname);
    exit(1);
  }

  read_pkts();

  close(fin);



  /* Your code to parse each packet and print information goes here */

}






