/** @file levels.h
 *  @brief Level description prototypes
 *
 *  @author Claire Tokar (ctokar) 
 *  @bug No known bugs.
 */

#ifndef _LEVELS_H_
#define _LEVELS_H_

#define MAX_LEVELS 32

/** The struct containing level map information
  *
  * height - The height of the level in lines \n
  * map - An integer array consisting of size height.  Each entry is an offset from a base of 0. \n
  * 0 is considered as the base left line and each offset is +/- relative to this 0.
  */
typedef struct drivelevel {
  int height;       
  int map [];       
} drivelevel_t;

drivelevel_t *levels[MAX_LEVELS];
int numlevels;

/** @brief Seeds the random number generator 
  * 
  * Seeds the random number generator using seed.  Must be called 
  * before init_levels.
  *
  * @param seed The seed to use in seeding the generator
  */
void seed_levels (int seed);


/** @brief Generates random map levels
  * 
  * Generates num_levels random map levels of height height.  And stores them 
  * in the levels[] array.
  * Should be called AFTER seed_levels
  * 
  * @param num_levels The number of levels to generate.  Must be less than or equal to MAX_LEVELS
  * @param height The desired height of each level
  * @param max_left_offset The maximum offset from 0 allowed in the left direction
  * @param max_right_offset The maximum offset from 0 allowed in the right direction
  * @return negative number on error, 0 on success
  */
int init_levels(int num_levels, int height, int max_left_offset, int max_right_offset);

#endif /* _LEVELS_H_ */
