#!/usr/local/bin/perl5

use strict;

my $prog = $0;

die "usage: $prog configname\n" unless $#ARGV == 0;

my $configname = $ARGV[0];

my @matches;
my $match;

open( TEST, "$configname" );
@matches = <TEST>;
close(TEST);

my $testrun;
my @funcalls;
my $i = 1;
my $died = 0;
my $fail_msg = "";
my $num_errors = 0;

foreach $match (@matches) {
  chomp($match);
  if ($match =~ "^NAME=(.*)") {
    my $test_cmd = $1;

    print "testing $test_cmd:\n";

    $testrun = `./$test_cmd 2>&1 && echo 410test_SUCCESS`;

    $died = -1 << 8 if ($testrun !~ "410test_SUCCESS\n");

    last if ($died) and $fail_msg =~ ".+";

    @funcalls = split(/Function/, $testrun);
  }
  elsif ($match =~ "^FAILURE_MSG=(.*)") {
    $fail_msg = $1;
    last if $died;
  }
  elsif ($match =~ "^FUNCTION=(.*)") {

    my $temp = scalar @funcalls;

    if ($i >= scalar @funcalls)
      {
	$num_errors++;
	print ("out of lines\n");
	next;
      };
    my $matcharg = $1;
    my @temp = split(/;/,$matcharg);
    my $matchreg = join(".*",@temp);
    my $psuedomatchreg = @temp[0];
    my $funcall = @funcalls[$i++];

    # matches, do nothing
    if ($funcall =~ /$matchreg/) {

    }
    # sort of matches, complain
    elsif ($funcall =~ /$psuedomatchreg/) {
      print ("Line \"$funcall\" does not match perfectly\n");
      $num_errors++;
    }
    # doesn't match at all
    else {
      print ("Line \"$funcall\" does not match at all\n");
      $num_errors++;
    }
  }
}

print ("test complete - $num_errors errors\n");
