/* The 15-410 reference kernel.
 * syscall_int.h
 *
 * Prototypes for assembly language wrappers for the
 * system call interface.
 *
 * Adam Chlipala (adamc)
 * Jorge Vittes (jvittes)
 * Zachary Anderson (zra)
 */

#ifndef _SYSCALL_INT_H
#define _SYSCALL_INT_H

#define SYSCALL_INT         0x40
#define FORK_INT            0x41
#define EXEC_INT            0x42
#define EXIT_INT            0x43
#define WAIT_INT            0x44
#define YIELD_INT           0x45
#define DESCHEDULE_INT      0x46
#define MAKE_RUNNABLE_INT   0x47
#define GETTID_INT          0x48
#define NEW_PAGES_INT       0x49
#define REMOVE_PAGES_INT    0x4A
#define SLEEP_INT           0x4B
#define GETCHAR_INT         0x4C
#define READLINE_INT        0x4D
#define PRINT_INT           0x4E
#define SET_TERM_COLOR_INT  0x4F
#define SET_CURSOR_POS_INT  0x50
#define GET_CURSOR_POS_INT  0x51
#define THREAD_FORK_INT     0x52
#define GET_TICKS_INT       0x53
#define MISBEHAVE_INT       0x54
#define HALT_INT            0x55
#define LS_INT              0x56

#endif /* _SYSCALL_INT_H */
