/** @file traceback.h
 *  @brief Function prototype for traceback library and types
 *
 *  This file should only be included by the files that form
 *  the traceback library. Test programs should include
 *  traceback.h instead.
 *
 *  DO NOT EDIT THIS FILE
 *
 *  @author Michael Ashley-Rollman(mpa)
 */

#ifndef __traceback_internal_h_
#define __traceback_internal_h_

#include "traceback.h"

/* type definitions */
#define TYPE_CHAR 0
#define TYPE_INT 1
#define TYPE_FLOAT 2
#define TYPE_DOUBLE 3
#define TYPE_STRING 4
#define TYPE_STRING_ARRAY 5
#define TYPE_UNKNOWN -1

/* type info definitions */
#define ARGS_MAX_NUM 6       /* The maximum number of arguments
				a single function can have */
#define ARGS_MAX_NAME 24     /* The maximum length of the name of
				an argument */
#define FUNCTS_MAX_NUM 4096  /* The maximum number of functions
				that traceback will support */
#define FUNCTS_MAX_NAME 60   /* The maximum length of the name of
				a function */

/**
 * @brief a structure to hold that data for a function argument
 */
typedef struct {
  /* The c-type of the argument ie: int, char, float, etc. */
  int type;

  /* The offset from %ebp of the argument */
  int offset;

  /* The name of the argument */
  char name[ARGS_MAX_NAME];
} argsym_t;

/**
 * @brief a structure to hold the data representing a function
 */
typedef struct {
  /* The address where the function starts */
  void *addr; 

  /* The name of the function */
  char name[FUNCTS_MAX_NAME];

  /* A list of the arguments that this function takes */
  argsym_t args[ARGS_MAX_NUM]; 
} functsym_t;

/*
 * list of all the functions in the program
 */
extern const functsym_t functions[FUNCTS_MAX_NUM];

#endif /* __traceback_internal_h_ */
