/*
 * As you can see, you can perform c style comments in .S files.	
 * You may also use precompiler directives like #include and #define
 */
	
.global add_one

//#define IGNORE_GOOD_STYLE

#ifdef IGNORE_GOOD_STYLE
	
/* This function works and technically is slightly faster.
 * For the sake of your sanity and for making debugging easier,
 * we recommend that you avoid the temptation of writing code
 * like this
 */
add_one:
	movl	4(%esp),%eax	# get the argument
	addl	$1,%eax		# add one to it and return it
	ret
#else

/* This function is far better style
 */
add_one:
	# standard preheader
	pushl	%ebp		
	movl	%esp,%ebp	
	pushl	%edi
	pushl	%ebx
	pushl	%esi
	# end preheader
	
        movl	8(%ebp),%eax	# get the argument
        addl	$1,%eax		# add one to it

	# standard postheader
	popl	%esi
	popl	%ebx
	popl	%edi
	movl	%ebp,%esp
	popl	%ebp
	# end postheader
	ret
#endif
