#!/usr/local/bin/perl -w

#
# This is a perl script for downloading the files not included in the handout
#
# Michael Ashley-Rollman(mpa)
#

use strict;

my $config = "config.mk";
my $afs_path = "/afs/cs.cmu.edu/academic/class/15410-f04/Web/update/proj4";
my $web_url  = "http://www-2.cs.cmu.edu/~410/update/proj4";

open (FILE, $config) || die "unable to read $config: $!";

my $config_line;
my $update_method = "";

# get update method from config file
foreach $config_line (<FILE>) {
    $update_method = $1 if ($config_line =~ "^UPDATE_METHOD.*=(.*)");
}
chomp $update_method;

if ($update_method =~ "afs") {
  `cp $afs_path/update.sh .`;
}
elsif ($update_method =~ "web") {
  `wget $web_url/update.sh`;
  `chmod +x update.sh`;
}
else {
  die "UPDATE_METHOD must be set to either \"afs\" or \"web\" in config.mk\n";
}

system("./update.sh $update_method 2>/dev/null");

