/** @file levels.h
 *  @brief Level description prototypes
 *
 *  @author Michael Berman (mberman)
 *  @bug No known bugs.
 */

#ifndef _LEVELS_H_
#define _LEVELS_H_

#define MAX_LEVELS 32

// a struct containing information about one level in sokoban 
// The actual level map is stored a string in the member variable
// map.  
// If you look at the structures defined in levels.c you can see 
// that walls are stored as 'X', the initial position of the 
// player as 'o', blocks as 'b', and goal squares as 'g'.  
// You can use this information to draw the game in a visually 
// appealing way.
typedef struct sokolevel {
  int width;
  int height;
  char * map;
} sokolevel_t;

sokolevel_t *levels[MAX_LEVELS];
int numlevels;

#endif /* _LEVELS_H_ */
