/* The 15-410 project set
 *
 *    disk.h
 *
 *  Definitions and prototypes for
 * manipulating an ide hard disk drive.
 *
 */

#ifndef _DISK_H
#define _DISK_H

/* Registers */
#define IDE_DATA_REGISTER		0x1f0
#define IDE_ERROR_REGISTER		0x1f1
#define IDE_SECTOR_COUNT_REGISTER	0x1f2
#define IDE_SECTOR_NUMBER_REGISTER	0x1f3
#define IDE_CYLINDER_LOW_REGISTER	0x1f4
#define IDE_CYLINDER_HIGH_REGISTER	0x1f5
#define IDE_DRIVE_HEAD_REGISTER		0x1f6
#define IDE_STATUS_REGISTER		0x1f7
#define IDE_COMMAND_REGISTER		0x1f7
#define IDE_DEVICE_CONTROL_REGISTER	0x3F6

/* Drives */
#define IDE_DRIVE_0			0xa0
#define IDE_DRIVE_1			0xb0

/* Commands */
#define IDE_COMMAND_IDENTIFY_DRIVE	0xec
#define IDE_COMMAND_SEEK		0x70
#define IDE_COMMAND_READ_SECTORS	0x21
#define IDE_COMMAND_READ_BUFFER		0xE4
#define IDE_COMMAND_WRITE_SECTORS	0x30
#define IDE_COMMAND_WRITE_BUFFER	0xE8
#define IDE_COMMAND_DIAGNOSTIC		0x90

/* Results words from Identify Drive Request */
#define	IDE_IDENTIFY_NUM_CYLINDERS	0x01
#define	IDE_IDENTIFY_NUM_HEADS		0x03
#define	IDE_IDENTIFY_NUM_BYTES_TRACK	0x04
#define	IDE_IDENTIFY_NUM_BYTES_SECTOR	0x05
#define	IDE_IDENTIFY_NUM_SECTORS_TRACK	0x06

/* Bits of Status Register */
#define IDE_STATUS_DRIVE_BUSY		0x80
#define IDE_STATUS_DRIVE_READY		0x40
#define IDE_STATUS_DRIVE_WRITE_FAULT	0x20
#define IDE_STATUS_DRIVE_SEEK_COMPLETE	0x10
#define IDE_STATUS_DRIVE_DATA_REQUEST	0x08
#define IDE_STATUS_DRIVE_CORRECTED_DATA	0x04
#define IDE_STATUS_DRIVE_INDEX		0x02
#define IDE_STATUS_DRIVE_ERROR		0x01

/* Bits of error register */
#define IDE_ERROR_MARK                  0x01
#define IDE_ERROR_TRK0                  0x02
#define IDE_ERROR_ABORT                 0x04
#define IDE_ERROR_CHANGERQ              0x08
#define IDE_ERROR_ID                    0x10
#define IDE_ERROR_CHANGED               0x20
#define IDE_ERROR_ECC                   0x40
#define IDE_ERROR_BADSEC                0x80

/* Bits of device control register */
#define IDE_DCR_NOINTERRUPT		0x02
#define IDE_DCR_RESET			0x04

/* Primary IDE controller IRQ number */
#define IDE_IRQ				14

/* IDE_BUSY codes. */
#define IDE_BUSY_DIAGNOSTIC 3
#define IDE_BUSY_WRITE 1
#define IDE_BUSY_READ 2
#define IDE_NOT_BUSY 0

#define SECTOR_SIZE 512

#define DISK_IDT_ENTRY 0x2e

typedef struct _disk {
  int cyl, heads, spt;
  int blks;
} disk_t;

typedef void (*disk_callback_t)( void );

void disk_handler(); /* interrupt handler -- you install in IDT */

int disk_init(disk_callback_t read_callback, disk_callback_t write_callback);

int disk_sectors(); /* how many sectors on disk? */

void disk_write_sector(int sector_num, char* source, int sector_count );
void disk_read_sector(int sector_num, char* dest, int sector_count );

#endif /* _DISK_H */
