/* The 15-410 kernel.
 * syscall.h
 *
 * Prototypes for the user land C library interface 
 * to system calls.
 *
 */

#ifndef _SYSCALL_H
#define _SYSCALL_H

#define NORETURN __attribute__((__noreturn__))

int fork(void);
int exec(char *execname, char *argvec[]);
void exit(int status) NORETURN;
int wait(int *status_ptr);
int yield(int pid);
int deschedule(int *flag);
int make_runnable(int pid);
int getpid(void);
int brk(void *addr);
int sleep(int ticks);
char getchar(void);
int readline(int size, char *buf);
int print(int size, char *buf);
int set_term_color(int color);
int set_cursor_pos(int row, int col);
int minclone(void);
int rand(void);
void halt();

#endif /* _SYSCALL_H */
