#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include <assert.h>

#define ERROR             -1
#define SUCCESS           0
#define MAX_ARRAY_BOUND   4

#define handle_error_en(en, msg) do { errno = en; printf("%s: ", msg); exit(EXIT_FAILURE); } while (0)

int nondet_int(void);
char nondet_char(void);

typedef char elem;

typedef struct ubarray_record ubarray;
struct ubarray_record {
  int size;
  int bound;
  elem *data;
};

/* Helper functions for assume and assert statements. 
   You may write additional helper functions. */

unsigned char valid_ubarray(ubarray *a)
{
  return a != NULL && a->size >= 0 && a->bound >= 0 && a->data != NULL && a->size <= a->bound;
}

elem* copy_data(ubarray *a) 
{
  elem *e = malloc(a->size*sizeof(elem));
  for (int i = 0; i < a->size; i++)
    e[i] = a->data[i];

  return e;
}

/* Main functions for unbounded arrays */

ubarray *ubarray_new(int init_bound)
{
  if(init_bound <= 0 || init_bound > MAX_ARRAY_BOUND)
    return NULL;

  ubarray *a = malloc(sizeof(ubarray));
  if(a != NULL) {
    a->size = 0;
    a->bound = init_bound;
    a->data = (elem*)malloc(init_bound*sizeof(elem));
    for (int i = 0 ; i < init_bound; i++)
      a->data[i] = 0;
  }

  return a;
}

int uba_size(ubarray *a)
{
  return a->size;
}

int uba_resize(ubarray *a, int new_bound)
{
  if(new_bound > MAX_ARRAY_BOUND)
    handle_error_en(ERROR, "out of memory");

  elem *b = malloc(new_bound*sizeof(elem));
  for (int i = 0; i < new_bound; i++)
    b[i] = 0;

  for(int i = 0; i <= a->size; i++)
    b[i] = a->data[i];
  free(a->data);
  a->bound = new_bound;
  a->data = b;

  return SUCCESS;
}

int uba_add(ubarray *a, elem e)
{
  if(a->size == a->bound)
    uba_resize(a, 2*a->bound);

  a->data[++(a->size)] = e;
  return SUCCESS;
}

elem uba_get(ubarray *a, int idx)
{
  return a->data[idx];
}

int uba_set(ubarray *a, int idx, elem e)
{
  a->data[idx] = e;
  return SUCCESS;
}

int uba_rem(ubarray *a)
{
  a->data[(a->size)--] = 0;
  return SUCCESS;
}

/* Harness functions - to be completed ... */

ubarray * ubarray_harness_init() {
  /* Write your test harness for an initialization of an 
     unbounded array implementation with one arbitrary element */

  return NULL;
}

void ubarray_harness_resize() {
  /* Write your test harness for arbitrary resize of an unbounded array.
     Note you can initialize your array with the ubarray_harness_init() 
     function. */
}

void ubarray_harness_get(){
  /* Write your test harness for arbitrary get of an unbounded array.
     Note you can initialize your array with the ubarray_harness_init() 
     function. */
}

void ubarray_harness_set(){
  /* Write your test harness for arbitrary set of an unbounded array.
     Note you can initialize your array with the ubarray_harness_init() 
     function. */
}

void ubarray_harness_rem(){
  /* Write your test harness for arbitrary rem of an unbounded array.
     Note you can initialize your array with the ubarray_harness_init() 
     function. */
}

int main()
{
  return SUCCESS;
}
