/* -*- Mode: C++ -*- */

/* trainer/epoch.h
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains the definitions for the epoch controller.
   See the README file for an explantion of the interaction between the
   epoch controller, the TrainingInfo class, and the training module */


#ifndef _EPOCH_H_
#define _EPOCH_H_

#include "types.h"
#include "MemPosition.h"

class EpochController;

/* this is a pure virtual base class to base training modules on */
class TrainingModule
{
 public:
  virtual Bool Initialize() {return TRUE;}
  virtual void InitializeEpochController(EpochController*) {}
  virtual void NewSightHandler() {}
  /* at some point the trainer may want to listen to the players,
     but that's not set up right now */
  /* virtual void NewSoundHandler() */

  virtual void LogHeader(EpochController*) {}
  virtual void LogPerformance(EpochController*) {}
  virtual void ResetForEpoch() {}
} ;



/* the training module fills in option_names with the appropriate
   strings and the the training_epochs array with the values for
   each epoch */

union DataVal
{
  Bool b;
  int  i;
  float f;
} ;

class EpochController 
{
 public:
  EpochController();
  
  const int MAX_NUM_EPOCHS = 2000;
  const int MAX_VARS = 5;

  /* these four things must be set by the training module! */
  char option_names[MAX_VARS][MAX_OPTION_LENGTH]; /* no '-' */
  TrainerValueType option_types[MAX_VARS];
  DataVal training_epochs[MAX_NUM_EPOCHS][MAX_VARS];
  int num_epochs;
  int num_vars;

  /* will call into the TM as appropriate */
  void NewSightHandler(TrainingModule* pTM);
  void ShutdownNotification(TrainingModule* pTM);

  /* these are for Training Modules to call back into to write strings */
  void WriteOptionNames(ostream& out);
  void WriteCurrentOptionValues(ostream& out);

  int GetCurrentEpoch() { return curr_epoch; }
  
private:
  int curr_epoch;
  int curr_epoch_elapsed;
};




#endif
