/* -*- Mode: C++ -*- */

/* trainer/epoch.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains the implementation for the epoch controller.
   See the README file for an explantion of the interaction between the
   epoch controller, the TrainingInfo class, and the training module */

#include <stdio.h>
#include <string.h>
#include "epoch.h"
#include "client.h"

EpochController::EpochController()
{
  num_epochs = num_vars = 0;
  curr_epoch = -1;
  curr_epoch_elapsed = 0;
}


void EpochController::NewSightHandler(TrainingModule* pTM)
{
  pTM->NewSightHandler();
  
  if (!Mem->TP_use_epochs)
    return;
  if (curr_epoch == -1 ||
      ++curr_epoch_elapsed >= Mem->TP_epoch_length) {
    /* close off this epoch and start another one */
    if (curr_epoch == -1) {
      if (Mem->TP_epoch_start == 0) {
	/* only write header if we start at 0 */
	pTM->LogHeader(this);
	cout << "Wrote header to file" << endl;
      }
      cout << "Using " << num_epochs << " epochs of "
	   << Mem->TP_epoch_length << " cycles each." << endl;
      cout << "Starting at epoch " << Mem->TP_epoch_start << " for "
	   << (Mem->TP_epochs_to_run == -1 ? num_epochs : Mem->TP_epochs_to_run)
	   << " epochs." << endl;
      curr_epoch = Mem->TP_epoch_start;
    } else {
      pTM->LogPerformance(this);
      cout << "Logged epoch " << curr_epoch << endl;
      curr_epoch++;
    }
    
    if (curr_epoch >= num_epochs ||
	(Mem->TP_epochs_to_run != -1 &&
	 curr_epoch >= Mem->TP_epoch_start + Mem->TP_epochs_to_run)) {
      cout << "Training is finished. Trainer shutting down" << endl;
      Mem->ShutDown = TRUE;
    } else {
      /* let's start the next epoch! */
      /* notify the client of a parameter change */
      char outstring[100];
      char temp[50];

      outstring[0] = 0;

      for (int i=0; i<num_vars; i++) {
	switch (option_types[i]){
	case TVT_OnOff: sprintf(temp, "-%s %s ", option_names[i],
				training_epochs[curr_epoch][i].b ? "on" : "off");
	break;
	case TVT_Int: sprintf(temp, "-%s %d ", option_names[i],
			      training_epochs[curr_epoch][i].i);
			      break;
	case TVT_Float: sprintf(temp, "-%s %f ", option_names[i],
			      training_epochs[curr_epoch][i].f);
	break;
	default:
	  my_error("Bad option type in EpochController: %d %d",
		   i, option_types[i]);
	  break;
	}
	
	strcat(outstring, temp);
      }
      
      //cout << "I'm saying:" << outstring << ":" << endl;
      Say(outstring);
      /* reset the counting values */
      curr_epoch_elapsed = 0;
      pTM->ResetForEpoch();
    }
  } /* epoch is finished */
}


void EpochController::ShutdownNotification(TrainingModule*)
{
  /* NOTE TO SELF: maybe want to write partial stats? */
}


void EpochController::WriteOptionNames(ostream& out)
{
  for (int i=0; i<num_vars; i++)
    out << option_names[i] << " ";
}

void EpochController::WriteCurrentOptionValues(ostream& out)
{
  for (int i=0; i<num_vars; i++) {
    switch (option_types[i]){
    case TVT_OnOff: out << (training_epochs[curr_epoch][i].b ? "on" : "off") << "\t";
    break;
    case TVT_Int: out << training_epochs[curr_epoch][i].i << "\t";
    break;
    case TVT_Float: out << training_epochs[curr_epoch][i].f << "\t";
    break;
    default:
      my_error("Bad option type in EpochController: %d %d",
	       i, option_types[i]);
      break;
    }
  }
  
}

