/* -*- Mode: C -*- */

/* trainer/MemOption.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains the definitions for the main program for the off-lien trainer */

#ifndef _CLIENT_H_
#define _CLIENT_H_

#include "Memory.h"

extern Memory *Mem;

#define NOANG 400

/* command functions */
void ChangeMode(Pmode pm);
void CheckBall();
void Ear(Bool OnOff);
void Eye(Bool OnOff);
void Look();
void MoveBall(Vector pos);
inline void MoveBall(float X, float Y)
  { MoveBall(Vector(X,Y)); }
void MoveBall(Vector pos, Vector vel);
inline void MoveBall(float X, float Y, float velX, float velY)
  { MoveBall(Vector(X,Y), Vector(velX, velY)); }
void MovePlayer(TeamSide side, Unum num, Vector pos, float ang = NOANG);
inline void MovePlayer(TeamSide side, Unum num, float X, float Y, float ang = NOANG)
{ MovePlayer(side, num, Vector(X,Y), ang); }
void Say(char* mess);
  

void disconnect();

#endif
