/* -*- Mode: C++ -*- */

/* trainer/TMturnball.h
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */


/* this is the training module for the turnball behavior*/

#ifndef _TMTURNBALL_H_
#define _TMTURNBALL_H_

#include "types.h"
#include "data.h"
#include "MemTrain.h"

class TMTurnball : public TrainingModule
{
 public:
  static const char* Name;
  
  Bool Initialize();
  void InitializeEpochController(EpochController* pEC);
  void NewSightHandler();
  void ShutdownNotification();

  void LogHeader(EpochController* pEC);
  void LogPerformance(EpochController* pEC);
  void ResetForEpoch();

private:
  int time_out_of_range;
  int target_angle; /* switches between 0 and 180 */
  int curr_turn_time;

  SingleDataSummary sdsTurnTime;
  int num_losses; /* number of times the client loses the ball */

  TurnDir turn_dir;

  void ResetBall();

} ;

#endif
