/* -*- Mode: C++ -*- */

/* trainer/TMtest.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */


/* this is the test training module */

#include <unistd.h>
#include "client.h"
#include "utils.h"
#include "TMtest.h"
#include "MemPosition.h"

const char* TMTest::Name = "Test";


Bool TMTest::Initialize()
{
  ChangeMode(PM_Play_On);

  outfile.open("TrainingData/cont.log");
  if (!outfile)
    my_error("Could not open the logfile");

  return TRUE;
}




void TMTest::NewSightHandler()
{
  /*
  if (Mem->GetTime() % 100 < 50) {
    if (Mem->GetBall()->pos.x > -20 ||
	Mem->GetBall()->pos.y > -20)
      MoveBall(range_random(-50, 50), range_random(-30, 30));
  } else {
    if (Mem->GetBall()->pos.x < 20 ||
	Mem->GetBall()->pos.y < 20)
      MoveBall(range_random(-50, 50), range_random(-30, 30));
  }
  */
  BallInfo* pBI = Mem->GetBall();

  /*
  float min_dist = 1000;
  Unum  min_player = Unum_Unknown;

  for (int num = 1; num <= Mem->SP_team_size; num++) {
    PlayerInfo* pPI = Mem->GetPlayer(TS_Left, num);
    if (pPI == NULL) continue;
    if (pBI->pos.dist(pPI->pos) < min_dist) {
      min_dist = pBI->pos.dist(pPI->pos);
      min_player = -num;
    }
  }

  for (int num = 1; num <= Mem->SP_team_size; num++) {
    PlayerInfo* pPI = Mem->GetPlayer(TS_Right, num);
    if (pPI == NULL) continue;
    if (pBI->pos.dist(pPI->pos) < min_dist) {
      min_dist = pBI->pos.dist(pPI->pos);
      min_player = num;
    }
  }

  if (min_dist >= Mem->SP_kickable_area)
    min_player = Unum_Unknown;
  outfile << Mem->GetTime() << '\t' << min_player << endl;

  */
  
  
  if (Mem->GetTime() % 100 == 1) {
    MoveBall(-15, 0);
    MovePlayer(TS_Left, 1, 0,0);
  }

  if (Mem->GetTime() % 100 == 20) {
    MoveBall(-15, 0, 2.7, 0);
  }    
  
  cout << "Time: " << Mem->GetTime() << "\tVel: " << pBI->vel.mod();

  if (pBI->vel.x < 0)
    cout << "\tBall moving backwards";

  cout << endl;
}

