/* -*- Mode: C++ -*- */

/* trainer/TMsetplay.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */


/* this is the training module for the setplay behavior */

#include <unistd.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include "client.h"
#include "utils.h"
#include "TMsetplay.h"
#include "MemPosition.h"

#define Debug(x) 

const char* TMSetplay::Name = "Setplay";

Bool TMSetplay::Initialize()
{
  Ear(TRUE);
  
  cout << "Setplay Training module" << endl;

  last_drop_ball_time = 0;

  return TRUE;
}


void TMSetplay::InitializeEpochController(EpochController* pEC)
{
  pEC->num_vars = 0;
  pEC->num_epochs = 1;
}


/* When there's a drop_ball, make a set-play instead */
void TMSetplay::NewSightHandler()
{
  pBallInfo pBI = Mem->GetBall();

#if 1
  /* Make the ball kickable for the goalie after a catch */
  PlayerInfo* pPI;
  if ( Mem->GetPlayMode() == PM_Free_Kick_Left &&
       Mem->GetPrevPlayMode(3) == PM_Free_Kick_Left ){
    pPI = Mem->GetPlayer(TS_Left, 1);
    if ( pPI != NULL && 
	 (pPI->pos.dist(pBI->pos) > Mem->SP_kickable_area) &&
	 (pPI->pos.dist(pBI->pos) < Mem->SP_catch_area_l) ){
      if ( 1|| pPI->pos.dist(Vector(-47,-9.16)) < 3 || pPI->pos.dist(Vector(-47,9.16)) < 3 ){
	MoveBall(pPI->pos.x,pPI->pos.y+(Mem->SP_kickable_area/2));
	printf("Moving ball at time %d\n",Mem->GetTime());
      }
    }
  }
  if ( Mem->GetPlayMode() == PM_Free_Kick_Right &&
       Mem->GetPrevPlayMode(3) == PM_Free_Kick_Right){
    pPI = Mem->GetPlayer(TS_Right, 1);
    if ( pPI != NULL && 
	 (pPI->pos.dist(pBI->pos) > Mem->SP_kickable_area) &&
	 (pPI->pos.dist(pBI->pos) < Mem->SP_catch_area_l) )
      MoveBall(pPI->pos.x,pPI->pos.y+(Mem->SP_kickable_area/2));
  }
#endif

  /**** Temporary -- going to be done by online coach ****/

#ifdef PETER_OLD_CODE  
  Pmode PlayMode = Mem->GetPlayMode();
  if ( PlayMode != PM_Play_On && Mem->GetPrevPlayMode(2) != PlayMode ){
    switch ( PlayMode ){
    case PM_Free_Kick_Left:
    case PM_Free_Kick_Right:
    case PM_Kick_In_Left:
    case PM_Kick_In_Right:
      char outstring[100];
      sprintf(outstring,"SetPlay (%f %f)",pBI->pos.x,pBI->pos.y);
      CoachSay(outstring);
      break;
    default:
      break;
    }
  }

  /****/
#endif

  if ( Mem->DropBallTime == last_drop_ball_time )
    return;

  last_drop_ball_time = Mem->DropBallTime;
  Vector ball = pBI->pos;

  /* kick offs */
  if ( ball.dist(Vector(0,0)) < 5 ){
    MoveBall(0,0);
    if ( ball.x < 0 )
      ChangeMode(PM_Kick_Off_Left);
    else
      ChangeMode(PM_Kick_Off_Right);
    return;
  }

  /* goal kicks */
  if ( ball.dist(Vector(-52.5,0)) < 5 ){
    ChangeMode(PM_Goal_Kick_Left);
    if ( ball.y < 0 )
      MoveBall(-47 ,-9.16);
    else
      MoveBall(-47 ,9.16);
    return;
  }
  if ( ball.dist(Vector(52.5,0)) < 5 ){
    ChangeMode(PM_Goal_Kick_Right);
    if ( ball.y < 0 )
      MoveBall(47 ,-9.16);
    else
      MoveBall(47 ,9.16);
    return;
  }

  /* corner kicks */
  if ( ball.dist(Vector(-52.5,-34)) < 5 ){
    ChangeMode(PM_Corner_Kick_Right);
    MoveBall(-52.5 ,-34);
    return;
  }
  if ( ball.dist(Vector(-52.5,34)) < 5 ){
    ChangeMode(PM_Corner_Kick_Right);
    MoveBall(-52.5 ,34);
    return;
  }
  if ( ball.dist(Vector(52.5,-34)) < 5 ){
    ChangeMode(PM_Corner_Kick_Left);
    MoveBall(52.5 ,-34);
    return;
  }
  if ( ball.dist(Vector(52.5,34)) < 5 ){
    ChangeMode(PM_Corner_Kick_Left);
    MoveBall(52.5 ,34);
    return;
  }

  /* kick-ins */
  if ( fabs(fabs(ball.y) - 34) < 5 ){
    if ( ball.y < 0 ){
      MoveBall(ball.x,-34);
      ChangeMode(PM_Kick_In_Left);
      return;
    }
    else{
      MoveBall(ball.x,34);
      ChangeMode(PM_Kick_In_Right);
      return;
    }
  }
}



void TMSetplay::LogHeader(EpochController* pEC)
{
}


void TMSetplay::LogPerformance(EpochController* pEC)
{
}

void TMSetplay::ResetForEpoch( )
{
  ;
}

