/* -*- Mode: C++ -*- */

/* trainer/TMkeepaway.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */

/* this is the training module for the keepaway behavior */

#include <unistd.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include "client.h"
#include "utils.h"
#include "TMkeepaway.h"
#include "MemPosition.h"

#define Debug(x) 

const char* TMKeepaway::Name = "Keepaway";

Bool TMKeepaway::Initialize()
{
  curr_def_cont_time = 0;
  curr_num_passes = 0;

  last_team_cont = Unum_Unknown;
  last_team_cont_time = 0;
  
  play_rect=Rectangle(Vector(0,0),
		      Vector(Mem->TP_keepaway_rect_length,
			     Mem->TP_keepaway_rect_width) );

  ChangeMode(PM_Play_On);
  
  cout << "Keepaway Training module" << endl;

  return TRUE;
}

/* ranges to check:
 */
void TMKeepaway::InitializeEpochController(EpochController* pEC)
{
  pEC->num_vars = 0;
  pEC->num_epochs = 1;
}


/* Does the following:
   If the ball goes outside of play_rect, it gives it to the left team inside of the
   rectangle.
   If the defenders control it for xx cycles, gives it back to left side
 */
/* Assumes: -The relevant player is the first one on the left team */
void TMKeepaway::NewSightHandler()
{
  pBallInfo pBI = Mem->GetBall();

  if (!play_rect.IsWithin(pBI->pos)) {
    sdsNumPasses.AddPoint((float) curr_num_passes);
    ResetBall();
  } else {

    for (int num = 1; num <= Mem->SP_team_size; num++) {
      PlayerInfo* pPI = Mem->GetPlayer(TS_Left, num);
      if (pPI == NULL) continue;

      if (pPI->pos.dist(pBI->pos) < Mem->SP_kickable_area) {
	if (last_team_cont != Unum_Unknown &&
	    last_team_cont_time != Mem->GetTime() &&
	    last_team_cont != pPI->num)
	  curr_num_passes++;

	last_team_cont = pPI->num;
	last_team_cont_time = Mem->GetTime();
	curr_def_cont_time = 0;
      }
    } /* offense loop */

    int num_controlling = 0;
    for (int num = 1; num <= Mem->SP_team_size; num++) {
      PlayerInfo* pPI = Mem->GetPlayer(TS_Right, num);
      if (pPI == NULL) continue;
      if (pPI->pos.dist(pBI->pos) < Mem->SP_kickable_area)
	num_controlling++;
    } /* defender loop */

    if (num_controlling > 0)
      curr_def_cont_time++;

    /* cout << "Time: " << Mem->GetTime()
	 << "\tdef_cont_time: " << curr_def_cont_time << endl; */
    if (curr_def_cont_time > Mem->TP_keepaway_max_def_cont_time) {
      sdsNumPasses.AddPoint((float) curr_num_passes);
      ResetBall(); 
    }
    
  }
}

void TMKeepaway::ResetBall()
{
  PlayerInfo* pPI = Mem->GetPlayer(TS_Left, 1);
  if (pPI == NULL) {
    my_error("Can't reset ball without player left 1");
    return;
  }

  MoveBall(pPI->pos + Polar2Vector(Mem->SP_kickable_area * .75, pPI->body_ang));
  
  last_team_cont = Unum_Unknown;
  curr_num_passes = 0;
  curr_def_cont_time = 0;
}



void TMKeepaway::LogHeader(EpochController* pEC)
{
  ofstream outfile;

  outfile.open(Mem->TP_training_log_fn, ios::out);
  if (!outfile) {
    my_error("Could not open data file: %s", Mem->TP_training_log_fn);
    return;
  }
    
  /* write header */
  outfile << "Training Info for Keepaway behavior" << endl;
  outfile << "Format: ";
  outfile << "Epoch Length is: " << Mem->TP_epoch_length << endl;

  outfile.close();
}


void TMKeepaway::LogPerformance(EpochController* pEC)
{
  ofstream outfile;

  /* NOTE TO SELF: need to end the epoch */
  
  outfile.open(Mem->TP_training_log_fn, ios::app);
  if (!outfile) {
    my_error("Could not open data file: %s", Mem->TP_training_log_fn);
    return;
  }

  outfile.close();
}

void TMKeepaway::ResetForEpoch( )
{
  /* reset the counting values */
  curr_def_cont_time = 0;
  curr_num_passes = 0;
  last_team_cont = Unum_Unknown;
  sdsNumPasses.Reset();
  
  /* reset the ball */
  ResetBall(); 
}

