/* -*- Mode: C++ -*- */

/* trainer/TMintercept2.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */

/* this is the training module for the intercept2 behavior */

#include <unistd.h>
#include <iostream.h>
#include <fstream.h>
#include "client.h"
#include "utils.h"
#include "TMintercept2.h"
#include "MemPosition.h"

const char* TMIntercept2::Name = "Intercept2";

Bool TMIntercept2::Initialize()
{
  ChangeMode(PM_Play_On);
  Ear(TRUE);
  
  curr_wait_time = 0;
  curr_poss_time = 0;

  cout << "Intercept2 Training module" << endl;
  
  return TRUE;
}

/* ranges to check:
   */
void TMIntercept2::InitializeEpochController(EpochController* pEC)
{
  pEC->num_vars = 0;
  pEC->num_epochs = 1;
}


/* Does the following: */
void TMIntercept2::NewSightHandler()
{
  
  pPlayerInfo pPI = Mem->GetPlayer(TS_Left, 1);
  if (pPI == NULL) {
    cout << "Trainer: Waiting for a player to connect" << endl;
    return; /* no players yet */
  }

  /* ball went out of bounds or something */
  if (Mem->GetPlayMode() != PM_Play_On) {
    ResetBallAndPlayer();
    ChangeMode(PM_Play_On);
  }
  
  
  pBallInfo pBI = Mem->GetBall();
  if (pBI->pos.dist(pPI->pos) < Mem->SP_kickable_area) {
    if (++curr_poss_time > Mem->TP_intercept2_max_poss_time) {
      ResetBallAndPlayer();      
    }    
  } else if (pBI->vel.mod() == 0) {
    /* ball is waiting to be kicked */
    if (++curr_wait_time > Mem->TP_intercept2_wait_time) {
      /* "kick" the ball */
      float ang = range_random(-Mem->TP_intercept2_max_ang,
			       Mem->TP_intercept2_max_ang);
      Vector vel = Polar2Vector(Mem->SP_ball_speed_max, ang);
      MoveBall(pBI->pos, vel);
      curr_wait_time = 0;
    }
  } else {
    /* player is intercepting the ball */
  }
  
}

void TMIntercept2::ResetBallAndPlayer()
{
  /* move_player */
  MovePlayer(TS_Left, 1, 0, 0, -180); /* facing left */

  /* move ball */
  MoveBall(-30, 0);

  /* reset counters */
  curr_wait_time = 0;
  curr_poss_time = 0;
}

void TMIntercept2::LogHeader(EpochController* pEC)
{
  my_error("TMintercept2: not for use with epochs");
}


void TMIntercept2::LogPerformance(EpochController* pEC)
{
  my_error("TMintercept2: not for use with epochs");
}

void TMIntercept2::ResetForEpoch()
{
  /* reset the ball and players*/
  ResetBallAndPlayer();
}

