/* -*- Mode: C++ -*- */

/* trainer/TMintercept.h
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */

/* this is the training module for the intercept behavior*/

#ifndef _TMINTERCEPT_H_
#define _TMINTERCEPT_H_

#include "types.h"
#include "data.h"
#include "MemTrain.h"

class TMIntercept : public TrainingModule
{
 public:
  static const char* Name;
  
  Bool Initialize();
  void InitializeEpochController(EpochController* pEC);
  void NewSightHandler();

  void LogHeader(EpochController* pEC);
  void LogPerformance(EpochController* pEC);
  void ResetForEpoch();

private:
  int curr_int_time;
  int time_since_kickable;
  /* number of times each side intercepts the ball */
  int left_ints, right_ints, tie_ints;
  
  SingleDataSummary sdsIntTime;

  void ResetBallAndPlayers();

  
} ;

#endif
