/* -*- Mode: C++ -*- */

/* trainer/TMintercept.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */


/* this is the training module for the intercept behavior */

#include <unistd.h>
#include <iostream.h>
#include <fstream.h>
#include "client.h"
#include "utils.h"
#include "TMintercept.h"
#include "MemPosition.h"

const char* TMIntercept::Name = "Intercept";

Bool TMIntercept::Initialize()
{
  ChangeMode(PM_Play_On);
  Ear(TRUE);
  
  curr_int_time = Mem->TP_intercept_max_int_time + 1;
  time_since_kickable = 0;
  left_ints = right_ints = tie_ints = 0;

  cout << "Intercept Training module" << endl;
  
  return TRUE;
}

/* ranges to check:
   -hard_kick_dist_buffer: 0 - .3 by .05 7
   -player_ang           : 0 - 180 by 20 10
   */
void TMIntercept::InitializeEpochController(EpochController* pEC)
{
}


/* Does the following:
   -puts the players randomly in a square around the origin
   -"kicks" the ball slightly randomly from a point on the left side of the
    field
   -when the players reach the ball, records who has it after xx cycles
   */
/* Assumes: -The relevant players are the first ones on left and right */
void TMIntercept::NewSightHandler()
{
  
  pPlayerInfo pPIL = Mem->GetPlayer(TS_Left, 1);
  pPlayerInfo pPIR = Mem->GetPlayer(TS_Right, 1);
  if (pPIL == NULL || pPIR == NULL) {
    cout << "Trainer: Waiting for a player to connect" << endl;
    return; /* no players yet */
  }

  /* taking too long to intercept or ball went out of bounds, just reset it */
  if (curr_int_time > Mem->TP_intercept_max_int_time ||
      Mem->GetPlayMode() != PM_Play_On) {
    ResetBallAndPlayers();
    ChangeMode(PM_Play_On);
  }
  
  
  pBallInfo pBI = Mem->GetBall();
  if (pBI->pos.dist(pPIL->pos) < Mem->SP_kickable_area ||
      pBI->pos.dist(pPIR->pos) < Mem->SP_kickable_area) {
    /* ball is kickable for someone */
    time_since_kickable++;
    if (time_since_kickable > Mem->TP_intercept_kickable_time) {
      /* record who intercepted */
      if (pBI->pos.dist(pPIL->pos) < Mem->SP_kickable_area) {
	if (pBI->pos.dist(pPIR->pos) < Mem->SP_kickable_area)
	  tie_ints++;
	else
	  left_ints++;
      } else
	right_ints++;

      sdsIntTime.AddPoint((float)curr_int_time);
      
      ResetBallAndPlayers();
    }
    
  } else {
    curr_int_time++;
  }
  
}

void TMIntercept::ResetBallAndPlayers()
{
  /* move_players */
  float x,y;
  x = range_random(-Mem->TP_intercept_player_square_size/2,
		   Mem->TP_intercept_player_square_size/2);
  y = range_random(-Mem->TP_intercept_player_square_size/2,
		   Mem->TP_intercept_player_square_size/2);
  MovePlayer(TS_Left, 1, x, y, 180); /* face towards left */
  x = range_random(-Mem->TP_intercept_player_square_size/2,
		   Mem->TP_intercept_player_square_size/2);
  y = range_random(-Mem->TP_intercept_player_square_size/2,
		   Mem->TP_intercept_player_square_size/2);
  MovePlayer(TS_Right, 1, x, y, 180); /* face towards left */

  /* move ball */
  float spd, ang;
  spd = range_random(Mem->TP_intercept_min_ball_speed_per*
		     Mem->SP_ball_speed_max,
		     Mem->SP_ball_speed_max);
  ang = range_random(-Mem->TP_intercept_ball_angle_var/2,
		     Mem->TP_intercept_ball_angle_var/2);
  Vector traj = Polar2Vector(spd, ang);
  MoveBall(Vector(Mem->TP_intercept_kick_point_x,
		  Mem->TP_intercept_kick_point_y),
	   traj);

  /* reset counters */
  curr_int_time = 0;
  time_since_kickable = 0;
}

void TMIntercept::LogHeader(EpochController* pEC)
{
  my_error("TMIntercept can not log info");
}


void TMIntercept::LogPerformance(EpochController* pEC)
{
  my_error("TMIntercept can not log info");
}

void TMIntercept::ResetForEpoch()
{
  /* reset the counting values */
  left_ints = right_ints = tie_ints = 0;
  /* reset the ball and players*/
  ResetBallAndPlayers();
}

