/* -*- Mode: C++ -*- */

/* trainer/TMhardkick2.h
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */

/* this is the training module for the hardkick2 behavior*/

#ifndef _TMHARDKICK2_H_
#define _TMHARDKICK2_H_

#include "types.h"
#include "data.h"
#include "MemTrain.h"

class TMHardKick2 : public TrainingModule
{
 public:
  static const char* Name;
  
  Bool Initialize();
  void InitializeEpochController(EpochController* pEC);
  void NewSightHandler();

  void LogHeader(EpochController* pEC);
  void LogPerformance(EpochController* pEC);
  void ResetForEpoch();

private:
  int time_out_of_range;
  int curr_kick_time;
  /* these two params affect where the ball starts */
  int starting_angle; /* moves around the player */
  float starting_per; /* how far out to start the ball */

  SingleDataSummary sdsKickVel;
  SingleDataSummary sdsKickTime;
  SingleDataSummary sdsKickAngle;

  void ResetBall();
  void IncrementPlace();
  
} ;

#endif
