/* -*- Mode: C++ -*- */

/* trainer/TMgoalie.h
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */

/* this is the training module for the goalie behavior*/

#ifndef _TMGOALIE_H_
#define _TMGOALIE_H_

#include "types.h"
#include "data.h"
#include "MemTrain.h"

class TMGoalie : public TrainingModule
{
 public:
  static const char* Name;
  
  Bool Initialize();
  void InitializeEpochController(EpochController* pEC);
  void NewSightHandler();
  void ShutdownNotification();

  void LogHeader(EpochController* pEC);
  void LogPerformance(EpochController* pEC);
  void ResetForEpoch();

private:
  int curr_wait_time;
  int curr_shot_time;
  Vector curr_spot;
  int curr_spot_grid_x, curr_spot_grid_y;
  float curr_targ;
  int shots_from_spot;

  struct SpotInfo 
  {
    int num_shots;
    int num_goals;
  } *aSpotInfo;

SpotInfo* Ref(SpotInfo* aSI, int x, int y);
  
  Rectangle ball_rect;
  
  void ResetBallAndPlayer();

} ;

#endif
