/* -*- Mode: C++ -*- */

/* trainer/TMgame.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this is a sample training module. See the README for details about this program */

/* this is the training module for the game behavior- just makes sure the ball
   doesn't get stuck, not moving for long periods of time
   This is useful for running unattneded games */

#include <unistd.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include "client.h"
#include "utils.h"
#include "TMgame.h"
#include "MemPosition.h"

#define Debug(x) 

const char* TMGame::Name = "Game";

Bool TMGame::Initialize()
{
  time_ball_not_moving = 0;
  Ear(TRUE);
  
  cout << "Game Training module" << endl;

  return TRUE;
}


void TMGame::InitializeEpochController(EpochController* pEC)
{
  pEC->num_vars = 0;
  pEC->num_epochs = 1;
}


void TMGame::NewSightHandler()
{
  pBallInfo pBI = Mem->GetBall();

  if (pBI->vel.mod() < Mem->TP_game_stopped_ball_vel) {
    if (++time_ball_not_moving > Mem->TP_game_max_stopped_ball_cycles) {
      if (pBI->pos != Vector(0,0))
	MoveBall(0,0);
      else {
	ChangeMode(PM_Play_On);
	time_ball_not_moving = 0;
      }
    }
  } else
    time_ball_not_moving = 0;

  /* Make the ball kickable for the goalie after a catch */
#if 0
  PlayerInfo* pPI;
  if ( Mem->GetPlayMode() == PM_Free_Kick_Left &&
       Mem->GetPrevPlayMode(3) == PM_Free_Kick_Left){
    pPI = Mem->GetPlayer(TS_Left, 1);
    if ( (pPI->pos.dist(pBI->pos) > Mem->SP_kickable_area) &&
	 (pPI->pos.dist(pBI->pos) < Mem->SP_catch_area_l) )
      MoveBall(pPI->pos.x,pPI->pos.y+(Mem->SP_kickable_area/2));
  }
  if ( Mem->GetPlayMode() == PM_Free_Kick_Right &&
       Mem->GetPrevPlayMode(3) == PM_Free_Kick_Right){
    pPI = Mem->GetPlayer(TS_Right, 1);
    if ( (pPI->pos.dist(pBI->pos) > Mem->SP_kickable_area) &&
	 (pPI->pos.dist(pBI->pos) < Mem->SP_catch_area_l) )
      MoveBall(pPI->pos.x,pPI->pos.y+(Mem->SP_kickable_area/2));
  }
#endif
}



void TMGame::LogHeader(EpochController* pEC)
{
}


void TMGame::LogPerformance(EpochController* pEC)
{
}

void TMGame::ResetForEpoch( )
{
  time_ball_not_moving = 0;
}

