/* -*- Mode: C++ -*- */

/* trainer/MemOption.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains the definition of the TrainingInfo class, which manages
   which training module is active */
/* If you add a training module, you need to add a line to the Initialize method
   in the .C file */

#ifndef _MEMTRAIN_H_
#define _MEMTRAIN_H_

#include "types.h"
#include "MemPosition.h"
#include "epoch.h"

class TrainingInfo : public PositionInfo
{
 private:
  TrainingModule* pTheTrainingModule;

public:
  /* NOTE TO SELF: this should be private, but TMhardkick access it directly */
  EpochController epoch_cont; 
  
  Bool Initialize();
  void NotifyTMOfSight();
  /* at some point the trainer may want to listen to the players,
     but that's not set up right now */
  void NotifyTMOfShutdown();
  
} ;


#endif
