/* -*- Mode: C++ -*- */

/* trainer/MemTrain.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains the implementation of the TrainingInfo class, which manages
   which training module is active */
/* If you add a training module, you need to add a line to the Initialize method */


#include "MemTrain.h"

/* these are the modules which need to be included here */
#include "TMtest.h"
#include "TMturnball.h"
#include "TMhardkick.h"
#include "TMintercept.h"
#include "TMdribble.h"
#include "TMgoalie.h"
#include "TMkeepaway.h"
#include "TMgame.h"
#include "TMhardkick2.h"
#include "TMsetplay.h"
#include "TMintercept2.h"
#include "TMturnball2.h"
#include "TMshot.h"
#include "TMbreakaway.h"

/* this selects which training module to Initialize */
Bool TrainingInfo::Initialize()
{
  if (strcmp(TP_training_module, TMTest::Name) == 0)
    pTheTrainingModule = new TMTest;
  else if (strcmp(TP_training_module, TMTurnball::Name) == 0)
    pTheTrainingModule = new TMTurnball;
  else if (strcmp(TP_training_module, TMHardKick::Name) == 0)
    pTheTrainingModule = new TMHardKick;
  else if (strcmp(TP_training_module, TMIntercept::Name) == 0)
    pTheTrainingModule = new TMIntercept;
  else if (strcmp(TP_training_module, TMDribble::Name) == 0)
    pTheTrainingModule = new TMDribble;
  else if (strcmp(TP_training_module, TMGoalie::Name) == 0)
    pTheTrainingModule = new TMGoalie;
  else if (strcmp(TP_training_module, TMKeepaway::Name) == 0)
    pTheTrainingModule = new TMKeepaway;
  else if (strcmp(TP_training_module, TMGame::Name) == 0)
    pTheTrainingModule = new TMGame;
  else if (strcmp(TP_training_module, TMHardKick2::Name) == 0)
    pTheTrainingModule = new TMHardKick2;
  else if (strcmp(TP_training_module, TMSetplay::Name) == 0)
    pTheTrainingModule = new TMSetplay;
  else if (strcmp(TP_training_module, TMIntercept2::Name) == 0)
    pTheTrainingModule = new TMIntercept2;
  else if (strcmp(TP_training_module, TMTurnball2::Name) == 0)
    pTheTrainingModule = new TMTurnball2;
  else if (strcmp(TP_training_module, TMShot::Name) == 0)
    pTheTrainingModule = new TMShot;
  else if (strcmp(TP_training_module, TMBreakaway::Name) == 0)
    pTheTrainingModule = new TMBreakaway;
  else
    my_error("Unrecognized training module: %s", TP_training_module);

  if (pTheTrainingModule == NULL) {
    my_error("Training module did not allocate");
    return FALSE;
  }

  pTheTrainingModule->Initialize();
  pTheTrainingModule->InitializeEpochController(&epoch_cont);
  
  return TRUE;
}

void TrainingInfo::NotifyTMOfSight()
{
  if (pTheTrainingModule)
    epoch_cont.NewSightHandler(pTheTrainingModule);
}

void TrainingInfo::NotifyTMOfShutdown()
{
  if (pTheTrainingModule)
    epoch_cont.ShutdownNotification(pTheTrainingModule);
}
