/* -*- Mode: C++ -*- */

/* trainer/MemOption.h
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains option file and command line processing and definitions. */
   

#ifndef _OPTIONS_H_
#define _OPTIONS_H_

#include "types.h"

struct option_t {
   char	optname[32] ;
   void	*vptr ;
   int	vsize ;
};

enum InputType{
 V_INT,
 V_FLOAT,
 V_BOOL,
 V_STRING,	
 V_ONOFF,		
 V_NONE		
};

#define PROGRAM_NAME "TRAINER"

#define MAX_TEAMNAME_LEN  20
#define MAX_HOST_LEN      50
#define MAX_FILE_LEN      256
#define MAX_FP_LEN        20
#define MAX_TREE_STEM_LEN 50

/* Things to be read at startup that never change */
class OptionInfo {
public:
  OptionInfo();
  void GetOptions(int, char**);

  /* trainer params */
  int TP_alarm_interval; /* in milliseconds */
  int TP_max_cycles_since_io;
  Bool TP_save_log;
  char TP_training_module[MAXNAMELEN];

  char TP_training_log_fn[MAX_FILE_LEN];
  int TP_epoch_length;
  Bool TP_use_epochs;
  int TP_epoch_start; /* used if we want to restart server */
  int TP_epochs_to_run;
  
  float TP_turnball_start_per;
  int TP_turnball_max_time_out;
  
  int TP_hardkick_max_time_out;
  int TP_hardkick_max_kick_time;
  int TP_hardkick_start_ang_inc;
  float TP_hardkick_start_per_inc;
  int TP_hardkick_player_ang_inc;

  int TP_intercept_max_int_time;
  int TP_intercept_kickable_time;
  int TP_intercept_kick_point_x;
  int TP_intercept_kick_point_y;
  float TP_intercept_player_square_size;
  float TP_intercept_min_ball_speed_per;
  float TP_intercept_ball_angle_var;

  int TP_dribble_max_time_out;
  float TP_dribble_start_ball_dist;

  float TP_goalie_rect_left_x;
  float TP_goalie_rect_length;
  float TP_goalie_rect_width;
  int TP_goalie_set_wait_time;
  int TP_goalie_max_shot_time;
  int TP_goalie_reset_wait_time;
  int TP_goalie_num_shot_targets;
  int TP_goalie_rect_x_steps;
  int TP_goalie_rect_y_steps;
  int TP_goalie_shots_per_loc;
  Bool TP_goalie_target_random;
  Bool TP_goalie_spot_random;
  float TP_goalie_corner_buffer;

  float TP_keepaway_rect_length;
  float TP_keepaway_rect_width;
  int TP_keepaway_max_def_cont_time;

  float TP_game_stopped_ball_vel;
  int   TP_game_max_stopped_ball_cycles;

  int TP_intercept2_max_poss_time;
  int TP_intercept2_wait_time;
  int TP_intercept2_max_ang;

  int TP_turnball2_max_time_out;
  int TP_turnball2_max_turn_time;
  int TP_turnball2_angle_buf;

  float TP_shot_min_dist;
  float TP_shot_max_dist;
  float TP_shot_max_ang;
  int TP_shot_max_time;
  float TP_shot_dist_inc;

  float TP_breakaway_min_dist;
  float TP_breakaway_max_dist;
  float TP_breakaway_max_ang;
  int TP_breakaway_max_time;
  float TP_breakaway_def_behind_dist;
  float TP_breakaway_def_max_ang;
  
#include <opt-incl.h>  

};

#endif

