/* -*- Mode: C++ -*- */

/* trainer/MemOption.C
 * CMUnited99 (code for off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains option file and command line processing and definitions. */

#include <iostream.h>
#include <stdlib.h>
#include "netif.h"
#include "MemOption.h"

/* setting defaults to match version 4.06 server.conf */
OptionInfo::OptionInfo()
{
  /* trainer params */
  TP_alarm_interval = 200;
  TP_max_cycles_since_io = 20;
  TP_save_log = TRUE;
  strcpy(TP_training_module, "test");

  strcpy(TP_training_log_fn, "Training/general.log");
  TP_epoch_length = 1000;
  TP_use_epochs = TRUE;
  TP_epoch_start = 0; 
  TP_epochs_to_run = -1; /* -1 indicates all of them */
    
  TP_turnball_start_per = .8;
  TP_turnball_max_time_out = 5;

  TP_hardkick_max_time_out = 10;
  TP_hardkick_max_kick_time = 15;
  TP_hardkick_start_ang_inc = 15;
  TP_hardkick_start_per_inc = .2;
  TP_hardkick_player_ang_inc = 20;

  TP_intercept_max_int_time = 100;
  TP_intercept_kickable_time = 5;
  TP_intercept_kick_point_x = -20;
  TP_intercept_kick_point_y = 20;
  TP_intercept_player_square_size = 5;
  TP_intercept_min_ball_speed_per = .5;
  TP_intercept_ball_angle_var = 60;

  TP_dribble_max_time_out = 8;
  TP_dribble_start_ball_dist = .5;

  TP_goalie_rect_left_x = -40.0;
  TP_goalie_rect_length = 15;
  TP_goalie_rect_width = 30;
  TP_goalie_set_wait_time = 10;
  TP_goalie_reset_wait_time = 10;
  TP_goalie_max_shot_time = 100;
  TP_goalie_num_shot_targets = 5;
  TP_goalie_rect_x_steps = 5;
  TP_goalie_rect_y_steps = 10;
  TP_goalie_shots_per_loc = 10;
  TP_goalie_target_random = TRUE;
  TP_goalie_spot_random = TRUE;
  TP_goalie_corner_buffer = .5;

  TP_keepaway_rect_length = 30;
  TP_keepaway_rect_width = 20;
  TP_keepaway_max_def_cont_time = 6;

  TP_game_stopped_ball_vel = .1;
  TP_game_max_stopped_ball_cycles = 300;

  TP_intercept2_max_poss_time = 5;
  TP_intercept2_wait_time = 10;
  TP_intercept2_max_ang = 30;

  TP_turnball2_max_time_out = 5;
  TP_turnball2_max_turn_time = 20;
  TP_turnball2_angle_buf = 10;

  TP_shot_min_dist = 5;
  TP_shot_max_dist = 30;
  TP_shot_max_time = 30;
  TP_shot_max_ang = 60;
  TP_shot_dist_inc = 1;

  TP_breakaway_min_dist = 15;
  TP_breakaway_max_dist = 30;
  TP_breakaway_max_time = 30;
  TP_breakaway_max_ang = 60;
  TP_breakaway_def_behind_dist = 10;
  TP_breakaway_def_max_ang = 30;


#include<opt-def.C>
}

void OptionInfo::GetOptions(int argc, char **argv)
{
  option_t opt[] = {

    {"alarm_interval",          (void *)&TP_alarm_interval,         V_INT},
    {"max_cycles_since_io",     (void *)&TP_max_cycles_since_io,    V_INT},

    {"training_module",         (void *)&TP_training_module,        V_STRING},
    {"training_log_fn",         (void *)&TP_training_log_fn,        V_STRING},
    {"epoch_length",            (void *)&TP_epoch_length,           V_INT},
    {"use_epochs",              (void *)&TP_use_epochs,             V_ONOFF},
    {"epoch_start",             (void *)&TP_epoch_start,            V_INT},
    {"epochs_to_run",           (void *)&TP_epochs_to_run,          V_INT},

    {"turnball_start_per",      (void *)&TP_turnball_start_per,     V_FLOAT},
    {"turnball_max_time_out",   (void *)&TP_turnball_max_time_out,  V_INT},

    {"hardkick_max_time_out",   (void *)&TP_hardkick_max_time_out,  V_INT},
    {"hardkick_max_kick_time",  (void *)&TP_hardkick_max_kick_time, V_INT},
    {"hardkick_start_ang_inc",  (void *)&TP_hardkick_start_ang_inc, V_INT},
    {"hardkick_start_per_inc",  (void *)&TP_hardkick_start_per_inc, V_FLOAT},
    {"hardkick_player_ang_inc",  (void *)&TP_hardkick_player_ang_inc, V_INT},

    {"intercept_max_int_time",       (void *)&TP_intercept_max_int_time,       V_INT},
    {"intercept_kickable_time",      (void *)&TP_intercept_kickable_time,      V_INT},
    {"intercept_kick_point_x",       (void *)&TP_intercept_kick_point_x,       V_INT},
    {"intercept_kick_point_y",       (void *)&TP_intercept_kick_point_y,       V_INT},
    {"intercept_player_square_size", (void *)&TP_intercept_player_square_size, V_FLOAT},
    {"intercept_min_ball_speed_per", (void *)&TP_intercept_min_ball_speed_per, V_FLOAT},
    {"intercept_ball_angle_var",     (void *)&TP_intercept_ball_angle_var,     V_FLOAT},

    {"dribble_max_time_out",         (void *)&TP_dribble_max_time_out,         V_INT},
    {"dribble_start_ball_dist",      (void *)&TP_dribble_start_ball_dist,      V_FLOAT},

    {"goalie_rect_left_x",           (void *)&TP_goalie_rect_left_x,           V_FLOAT},
    {"goalie_rect_length",           (void *)&TP_goalie_rect_length,           V_FLOAT},
    {"goalie_rect_width",            (void *)&TP_goalie_rect_width,            V_FLOAT},
    {"goalie_set_wait_time",         (void *)&TP_goalie_set_wait_time,         V_INT},
    {"goalie_reset_wait_time",       (void *)&TP_goalie_reset_wait_time,       V_INT},
    {"goalie_max_shot_time",         (void *)&TP_goalie_max_shot_time,         V_INT},
    {"goalie_num_shot_targets",      (void *)&TP_goalie_num_shot_targets,      V_INT},
    {"goalie_rect_x_steps",          (void *)&TP_goalie_rect_x_steps,          V_INT},
    {"goalie_rect_y_steps",          (void *)&TP_goalie_rect_y_steps,          V_INT},
    {"goalie_shots_per_loc",         (void *)&TP_goalie_shots_per_loc,         V_INT},
    {"goalie_target_random",         (void *)&TP_goalie_target_random,         V_ONOFF},
    {"goalie_spot_random",           (void *)&TP_goalie_spot_random,           V_ONOFF},
    {"goalie_corner_buffer",         (void *)&TP_goalie_corner_buffer,         V_FLOAT},

    {"keepaway_rect_length",         (void *)&TP_keepaway_rect_length,         V_FLOAT},
    {"keepaway_rect_width",          (void *)&TP_keepaway_rect_width,          V_FLOAT},
    {"keepaway_max_def_cont_time",   (void *)&TP_keepaway_max_def_cont_time,   V_INT},

    {"game_stopped_ball_vel",        (void *)&TP_game_stopped_ball_vel,        V_FLOAT},
    {"game_max_stopped_ball_cycles", (void *)&TP_game_max_stopped_ball_cycles, V_INT},

    {"intercept2_max_poss_time",     (void *)&TP_intercept2_max_poss_time,     V_INT},
    {"intercept2_wait_time",         (void *)&TP_intercept2_wait_time,         V_INT},
    {"intercept2_max_ang",           (void *)&TP_intercept2_max_ang,           V_INT},

    {"turnball2_max_time_out",       (void *)&TP_turnball2_max_time_out,       V_INT},
    {"turnball2_max_turn_time",      (void *)&TP_turnball2_max_turn_time,      V_INT},
    {"turnball2_angle_buf",          (void *)&TP_turnball2_angle_buf,          V_INT},

    {"shot_min_dist",                (void *)&TP_shot_min_dist,                V_FLOAT},
    {"shot_max_dist",                (void *)&TP_shot_max_dist,                V_FLOAT},
    {"shot_max_time",                (void *)&TP_shot_max_time,                V_INT},
    {"shot_max_ang",                 (void *)&TP_shot_max_ang,                 V_FLOAT},
    {"shot_dist_inc",                (void *)&TP_shot_dist_inc,                V_FLOAT},

    {"breakaway_min_dist",           (void *)&TP_breakaway_min_dist,           V_FLOAT},
    {"breakaway_max_dist",           (void *)&TP_breakaway_max_dist,           V_FLOAT},
    {"breakaway_max_time",           (void *)&TP_breakaway_max_time,           V_INT},
    {"breakaway_max_ang",            (void *)&TP_breakaway_max_ang,            V_FLOAT},
    {"breakaway_def_behind_dist",    (void *)&TP_breakaway_def_behind_dist,    V_FLOAT},
    {"breakaway_def_max_ang",        (void *)&TP_breakaway_def_max_ang,        V_FLOAT},

    
#include<opt-array.C>	
    {"\0",				NULL, 			       	0}
  } ;

#include<opt-code.C>
  
}



