/* shared/opt-def.C
 * CMUnited99 (shared code for on-line coach, off-line coach, and off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* all of the opt-* files are meant to be #included in the MemOptions of
   coach and trainer */

/* this file contains default values */

/* these are parameters for MemPosition */
  MP_cycles_to_store = 2;
  MP_save_log = FALSE;
  MP_left_team_name[0] = 0;
  MP_right_team_name[0] = 0;

/* Server params */
  /* no option flags for these */
  SP_pitch_length 	  = 105.0;
  SP_pitch_width 	  = 68.0;
  SP_pitch_margin	  = 5.0;
  SP_penalty_area_length  = 16.5;
  SP_penalty_area_width   = 40.32;
  SP_goal_area_length	  = 5.5;
  SP_goal_area_width	  = 18.32;
  SP_penalty_spot_dist    = 11.0;
  SP_corner_arc_r	  = 1.0;
  SP_free_kick_buffer     = 9.15;
  SP_after_goal_wait  	  = 50;
  SP_feel_distance        = 3.0;
  SP_num_lines            = 4;
  SP_num_markers          = 55;
  SP_unum_far_length      = 20.0;
  SP_unum_too_far_length  = 40.0;
  SP_team_far_length      = 40.0;
  SP_team_too_far_length  = 60.0;

  SP_version              = 4.06;
  SP_team_size            = 11;
  SP_half                 = 1;
  sprintf(SP_host,        "localhost");
  SP_goal_width           = 14.02;       
  SP_player_size          = 0.8;
  SP_player_decay         = 0.4;
  SP_player_rand 	  = 0.1;
  SP_player_weight	  = 60.0;
  SP_player_speed_max     = 32.0;
  SP_stamina_max	  = 2000.0;
  SP_stamina_inc          = 20.0;
  SP_recover_dec_thr      = 0.3;	
  SP_recover_dec          = 0.05; 	
  SP_recover_min          = 0.1; 	
  SP_effort_dec_thr       = 0.4;	
  SP_effort_min           = 0.1;	
  SP_effort_dec           = 0.05;	
  SP_effort_inc_thr       = 0.9;	
  SP_effort_inc           = 0.05;	
  SP_ball_size            = 0.085;		
  SP_ball_decay           = 0.96;	
  SP_ball_rand            = 0.05;		
  SP_ball_weight          = 0.2;;	
  SP_ball_speed_max       = 32.0;	
  SP_dash_power_rate      = 0.01;	
  SP_kick_power_rate      = 0.016;
  SP_kickable_margin      = 1.0;	
  SP_kickable_area        = SP_kickable_margin + SP_ball_size + SP_player_size;
  SP_catch_prob           = 1.0;	
  SP_catch_area_l         = 2.0;	
  SP_catch_area_w         = 1.0;	
  SP_catch_ban_cycle      = 5;
  SP_max_power            = 100;		
  SP_min_power            = -30;		
  SP_max_moment           = 180;		
  SP_min_moment           = -180;		
  SP_min_neck_angle       = -90.0;
  SP_max_neck_angle       = 90.0;
  SP_min_neck_moment      = -180.0;
  SP_max_neck_moment      = 180.0;
  SP_visible_angle        = 90.0;	
  SP_audio_cut_dist       = 50.0;	
  SP_dist_qstep           = 0.1;	
  SP_land_qstep           = 0.01;	
  SP_ckmargin             = 1.0;	
  SP_wind_dir             = 0.0;	
  SP_wind_force           = 0.0;
  SP_wind_rand            = 0.0;	
  SP_wind_none            = FALSE;
  SP_wind_random          = FALSE;
  SP_half_time            = 300;
  SP_port                 = 6000;
  SP_coach_port           = 6001;
  SP_olcoach_port         = 6002;
  SP_simulator_step       = 100;
  SP_send_step            = 150;
  SP_recv_step            = 10;
  SP_say_msg_size         = 512;
  SP_hear_max             = 2;
  SP_hear_inc             = 1;
  SP_hear_decay           = 2;
  SP_coach_mode           = FALSE;
  SP_coach_w_referee_mode = FALSE;
  SP_say_coach_cnt_max    = 128;
  SP_say_coach_msg_size   = 128;
  SP_send_vi_step         = 100;
  SP_look_step            = 100;
  SP_use_offside          = FALSE;
  SP_forbid_kickoff_offside = TRUE;
  SP_verbose              = TRUE;
  SP_offside_area         = 9.15;
  SP_inertia_moment       = 5.0;
  SP_sense_body_step      = 100;
  SP_offside_kick_margin  = 9.15;
  SP_record_messages      = FALSE;
