/* shared/opt-array.C
 * CMUnited99 (shared code for on-line coach, off-line coach, and off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* all of the opt-* files are meant to be #included in the MemOptions of
   coach and trainer */

/* this file is meant to be included in a MemOption.C
   this is the array needed for parsing */

/* these are parameters for MemPosition */
{"cycles_to_store",         (void *)&MP_cycles_to_store,        V_INT},
{"save_log",                (void *)&MP_save_log,               V_ONOFF},
{"left_team_name",          (void *)&MP_left_team_name,         V_STRING},
{"right_team_name",         (void *)&MP_right_team_name,        V_STRING},

  /* Server params */
{"version",        		(void *)&SP_version,          V_FLOAT},
{"team_size",        		(void *)&SP_team_size,          V_INT},
{"half",        		(void *)&SP_half,          V_INT},
{"host",             		(void *)&SP_host,               V_STRING},
{"goal_width",   		(void *)&SP_goal_width,         V_FLOAT},
{"player_size",   		(void *)&SP_player_size,	V_FLOAT},
{"player_decay",   	        (void *)&SP_player_decay,    	V_FLOAT},
{"player_rand",   		(void *)&SP_player_rand,	V_FLOAT},
{"player_weight",   	        (void *)&SP_player_weight,	V_FLOAT},
{"player_speed_max",            (void *)&SP_player_speed_max,	V_FLOAT},
{"stamina_max",   		(void *)&SP_stamina_max,	V_FLOAT},
{"stamina_inc_max",   	        (void *)&SP_stamina_inc,	V_FLOAT},
{"recover_dec_thr",   	        (void *)&SP_recover_dec_thr,	V_FLOAT},
{"recover_min",   		(void *)&SP_recover_min, 	V_FLOAT},
{"recover_dec",   		(void *)&SP_recover_dec, 	V_FLOAT},
{"effort_dec_thr",   	        (void *)&SP_effort_dec_thr,	V_FLOAT},
{"effort_min",   		(void *)&SP_effort_min, 	V_FLOAT},
{"effort_dec",   		(void *)&SP_effort_dec, 	V_FLOAT},
{"effort_inc_thr",   	        (void *)&SP_effort_inc_thr,	V_FLOAT},
{"effort_inc",   		(void *)&SP_effort_inc,	        V_FLOAT},
{"ball_size",   		(void *)&SP_ball_size,		V_FLOAT},
{"ball_decay",   		(void *)&SP_ball_decay, 	V_FLOAT},
{"ball_rand",   		(void *)&SP_ball_rand,		V_FLOAT},
{"ball_weight",   		(void *)&SP_ball_weight,	V_FLOAT},
{"ball_speed_max",   	        (void *)&SP_ball_speed_max,	V_FLOAT},
{"dash_power_rate",   	        (void *)&SP_dash_power_rate,	V_FLOAT},
{"kick_power_rate",   	        (void *)&SP_kick_power_rate,	V_FLOAT},
{"kickable_margin",   	        (void *)&SP_kickable_margin,	V_FLOAT},
{"catch_probability",   	(void *)&SP_catch_prob, 	V_FLOAT},
{"catchable_area_l",            (void *)&SP_catch_area_l,	V_FLOAT},
{"catchable_area_w",            (void *)&SP_catch_area_w,	V_FLOAT},
{"maxpower",   		        (void *)&SP_max_power,		V_FLOAT},
{"minpower",   		        (void *)&SP_min_power,		V_FLOAT},
{"maxmoment",   		(void *)&SP_max_moment,		V_FLOAT},
{"minmoment",   		(void *)&SP_min_moment,		V_FLOAT},
{"maxneckang",	    	        (void *)&SP_max_neck_angle,	V_FLOAT},
{"minneckang",		        (void *)&SP_min_neck_angle,	V_FLOAT},
{"maxneckmoment",		(void *)&SP_max_neck_moment,	V_FLOAT},
{"minneckmoment",		(void *)&SP_min_neck_moment,	V_FLOAT},
{"visible_angle",   	        (void *)&SP_visible_angle,	V_FLOAT},
{"visible_distance",            (void *)&SP_visible_dist,	V_FLOAT},
{"audio_cut_dist",   	        (void *)&SP_audio_cut_dist,	V_FLOAT},
{"quantize_step",   	        (void *)&SP_dist_qstep, 	V_FLOAT},
{"quantize_step_l",   	        (void *)&SP_land_qstep, 	V_FLOAT},
{"ckick_margin",   	        (void *)&SP_ckmargin,   	V_FLOAT},
{"wind_dir",   		        (void *)&SP_wind_dir,   	V_FLOAT},
{"wind_force",   		(void *)&SP_wind_force,  	V_FLOAT},
{"wind_rand",   		(void *)&SP_wind_rand,  	V_FLOAT},
{"wind_none",   		(void *)&SP_wind_none,  	V_BOOL},
{"wind_random",   		(void *)&SP_wind_random,	V_BOOL},
{"half_time",   		(void *)&SP_half_time,  	V_INT},
{"port",   			(void *)&SP_port,       	V_INT},
{"coach_port",   		(void *)&SP_coach_port,  	V_INT},
{"olcoach_port",	        (void *)&SP_olcoach_port,	V_INT},
{"simulator_step",   	        (void *)&SP_simulator_step,	V_INT},
{"send_step",   		(void *)&SP_send_step,  	V_INT},
{"recv_step",   		(void *)&SP_recv_step,  	V_INT},
{"say_msg_size",   	        (void *)&SP_say_msg_size,	V_INT},
{"hear_max",   		        (void *)&SP_hear_max,   	V_INT},
{"hear_inc",   		        (void *)&SP_hear_inc,   	V_INT},
{"hear_decay",   		(void *)&SP_hear_decay,  	V_INT},
{"catch_ban_cycle",             (void *)&SP_catch_ban_cycle,	V_INT},
{"coach",   			(void *)&SP_coach_mode,  	V_BOOL},
{"coach_w_referee",   	        (void *)&SP_coach_w_referee_mode,V_BOOL},
{"say_coach_cnt_max",               (void *)&SP_say_coach_cnt_max,V_INT},
{"say_coach_msg_size",          (void *)&SP_say_coach_msg_size,V_INT},
{"send_vi_step",                (void *)&SP_send_vi_step, V_INT},

{"look_step",                       (void *)&SP_look_step,V_INT},
{"use_offside",   		(void *)&SP_use_offside,	V_ONOFF},
{"forbid_kick_off_offside",     (void *)&SP_forbid_kickoff_offside, V_ONOFF},
{"log_file",		        (void *)&SP_logfile,		V_STRING},
{"record",			(void *)&SP_recfile,		V_STRING},
{"record_log",		        (void *)&SP_rec_log,		V_BOOL},
{"record_version",	        (void *)&SP_rec_ver,		V_INT},
{"send_log",	        (void *)&SP_send_log,		V_BOOL},
{"replay",			(void *)&SP_replay,		V_STRING},
{"verbose",                     (void *)&SP_verbose,		V_ONOFF},
{"offside_active_area_size",    (void *)&SP_offside_area,	V_FLOAT},
{"inertia_moment",      	(void *)&SP_inertia_moment,     V_FLOAT},
{"sense_body_step",      	(void *)&SP_sense_body_step,     V_INT},
{"offside_kick_margin",         (void *)&SP_offside_kick_margin, V_FLOAT},
{"record_messages",         (void *)&SP_record_messages,     V_ONOFF},
