/* -*- Mode: C++ -*- */

/* shared/netif.h
 * CMUnited99 (shared code for on-line coach, off-line coach, and off-line trainer)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1998 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Manuela Veloso, and Patrick Riley
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* shared/netif.h contains implementation for the common parts of the
   networking interface */

/*
 * Definitions for UDP c/s program.
 */

#ifndef __netif_h
#define __netif_h

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/time.h>

#ifdef Linux
#include <wait.h>
#endif
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#ifdef Linux
/*#include <linux/time.h>*/
#endif

#define DEFAULT_PORT_NUMBER	6000
#define MAXMESG			2048
#define MAXARG			200

#ifdef MEMSET
#define bzero(a, b) memset(a, 0, b)
#endif

#ifndef Linux
extern "C" void usleep(unsigned long);
#endif

#ifdef __cplusplus
class Socket {
 public:
  int			socketfd  ;
  struct sockaddr_in	serv_addr ;
};
#else
typedef struct socket{
    int			socketfd  ;
    struct sockaddr_in	serv_addr ;
}Socket ;
#endif

extern Socket init_connection(char* host, int port) ;
extern int    send_message(char* buf, Socket *sock) ;
extern int    receive_message(char *buf, Socket *sock) ;
extern void   close_connection(Socket *sock) ;

inline int wait_message(char *buf, Socket *sock) {
  if (receive_message(buf, sock) == 1) {
    while (receive_message(buf, sock) == 1);
    return 1;
  } 
  else for (int i = 0; i < 40; i++)  {
    if (receive_message(buf, sock) == 1) return 1;
    usleep(100000);
  }
  return 0;
}
#endif
