/* -*- Mode: C++ -*- */

/* coach/MemSetplay.C
 * CMUnited99 (code for on-line/off-line coach)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains implementation for the on-line coaching of set-plays */

#include <iostream.h>
#include "MemSetplay.h"
#include "client.h"

Bool SetplayInfo::Initialize()
{
  MySide = TS_NoValue;
  return TRUE;
}
  
void SetplayInfo::SetplaySightHandler(void)
{
  /* if ( (Mem->GetTime())%100 == 0 )
    printf("Coach still alive at %d\n",Mem->GetTime()); */

  if ( MySide == TS_NoValue ){
    if ( !strcmp(MP_left_team_name,CP_team_name) )
      MySide = TS_Left;
    else if ( !strcmp(MP_right_team_name,CP_team_name) )
      MySide = TS_Right;
    else
      my_error("Which side am I on???");
  }
  
  Vector ballPos = Mem->GetBall()->pos;
  Pmode PlayMode = Mem->GetPlayMode();

  if ( PlayMode != PM_Play_On && Mem->GetPrevPlayMode(1) != PlayMode ){
    switch ( PlayMode ){
    case PM_OffSide_Left:
    case PM_OffSide_Right:
    case PM_Free_Kick_Left:
    case PM_Free_Kick_Right:
    case PM_Kick_In_Left:
    case PM_Kick_In_Right:
      char outstring[100];
      if ( MySide == TS_Right ) ballPos = -ballPos; /* flip coords for right team */
      sprintf(outstring,"SetPlay (%f %f)",ballPos.x,ballPos.y);
      //printf("%s\n",outstring);
      Say(outstring);
      break;
    default:
      break;
    }
  }
}

void SetplayInfo::SetplayPlayerSoundHandler(void)
{
  //cout << "Setplay sound handler: " << CP_team_name << endl;
}

