/* -*- Mode: C++ -*- */

/* coach/MemOption.h
 * CMUnited99 (code for on-line/off-line coach)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains option file and command line processing and definitions.
   Note that many options may be meaningless in the released version of the code */

#ifndef _OPTIONS_H_
#define _OPTIONS_H_

#include "types.h"

struct option_t {
   char	optname[32] ;
   void	*vptr ;
   int	vsize ;
};

enum InputType{
 V_INT,
 V_FLOAT,
 V_BOOL,
 V_STRING,	
 V_ONOFF,		
 V_NONE		
};

#define PROGRAM_NAME "COACH"


#define MAX_TEAMNAME_LEN  20
#define MAX_HOST_LEN      50
#define MAX_FILE_LEN      256
#define MAX_FP_LEN        20
#define MAX_TREE_STEM_LEN 50
#define MAX_ADVCLASS_NAME_LEN 50

/* Things to be read at startup that never change */
class OptionInfo {
public:
  OptionInfo();
  void GetOptions(int, char**);

  /* coach params */
  int CP_alarm_interval; /* in milliseconds */
  int CP_max_cycles_since_io;

  Bool CP_just_observe; /* coach sends no commands */

  char CP_team_name[MAX_TEAMNAME_LEN];
  
  Bool CP_coach_setplays;

  Bool CP_analyze_log; /* will load a log file. If false, connects to server */
  char CP_log_fn[MAX_FILE_LEN];

  char CP_side_to_analyze[20];
  char CP_team_to_analyze[MAX_TEAMNAME_LEN];

  char CP_output_directory[MAX_FILE_LEN];
  
  Bool CP_take_stats;
  Bool CP_record_detail_stats;
  Bool CP_record_summary_stats;
  /* Adversarial Parameters */
  char CP_adversary_class_list_fn[MAX_FILE_LEN];
  Bool CP_classify_adversary; 

  Bool CP_show_progress;
  
  /* adversary classes can be created from observations, or randomly */
  Bool CP_create_adv_class;
  char CP_create_adv_class_list_fn[MAX_FILE_LEN];
  Bool CP_create_random_adv_class;
  char CP_create_adv_class_name[MAX_ADVCLASS_NAME_LEN];
  char CP_create_adv_class_out_fn[MAX_FILE_LEN];
  Bool CP_create_adv_class_calc_int_sim;
  
  Bool CP_record_similarity;
  Bool CP_record_adv_class_similarity; // uses the below output_fn
  char CP_record_similarity_output_fn[MAX_FILE_LEN];
  char CP_record_similarity_input_fn[MAX_FILE_LEN];
  char CP_record_similarity_class[MAX_ADVCLASS_NAME_LEN];

  Bool CP_write_DT_names_file;
  char CP_write_DT_names_fn[MAX_FILE_LEN];
  
  int  AP_epoch_length;
  Bool AP_record_opponent_positions;
  Bool AP_record_ball_position;
  Bool AP_record_ball_controller;
  Bool AP_record_passing_rects;
  Bool AP_record_dribble_rects;
  Bool AP_record_shot_rects;
  Bool AP_record_action_count;
  Bool AP_record_player_proximity;

  int  OP_rg_rows;
  int  OP_rg_cols;
  int  OP_rg_vals;

  int  OP_pass_timeout;
  int  OP_pass_num_past_cont;
  float OP_min_pass_dist;

  int  OP_drib_num_past_cont;
  int  OP_max_drib_cntl_intvl;
  float OP_min_drib_dist;

  int OP_shot_num_past_cont;
  int OP_shot_cntl_timeout;
  float OP_shot_goal_buf;

  int OP_opp_pos_match_var; 

  float CP_control_buffer; /* added to kickable area to determine if
			      the ball is 'controlled' by a player */


  
#include <opt-incl.h>  

};

#endif

