/* -*- Mode: C++ -*- */

/* coach/MemOption.C
 * CMUnited99 (code for on-line/off-line coach)
 * Patrick Riley <pfr+@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1999 Patrick Riley
 *
 * CMUnited-99 was created by Peter Stone, Patrick Riley, and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* this file contains option file and command line processing and definitions.
   Note that many options may be meaningless in the released version of the code */


#include <iostream.h>
#include <stdlib.h>
#include "netif.h"
#include "MemOption.h"

OptionInfo::OptionInfo()
{
  /* coach params */
  CP_alarm_interval = 200;
  CP_max_cycles_since_io = 20;

  CP_just_observe = FALSE;

  CP_analyze_log = TRUE;
  CP_log_fn[0] = 0;

  strcpy(CP_output_directory, "Stats/");

  strcpy(CP_side_to_analyze, "NoValue");
  CP_team_to_analyze[0] = 0;

  strcpy(CP_team_name, "CMUnited");
  
  /* these are for setplays */
  CP_coach_setplays = FALSE;
  
  /* these are from the thesis work */
  CP_take_stats = TRUE;
  CP_record_detail_stats = TRUE;
  CP_record_summary_stats = TRUE;

  CP_control_buffer = .4;

  CP_show_progress = FALSE;
  
  strcpy(CP_create_adv_class_list_fn, "AdvClass/obs/combine.list");
  CP_create_adv_class = FALSE; 
  CP_create_random_adv_class = FALSE; 
  strcpy(CP_create_adv_class_name, "Combined Adversary Class");
  strcpy(CP_adversary_class_list_fn, "AdvClass/class.list");  
  CP_create_adv_class_out_fn[0] = 0;
  CP_create_adv_class_calc_int_sim = TRUE;

  CP_record_similarity = FALSE;
  CP_record_adv_class_similarity = FALSE;
  CP_record_similarity_output_fn[0] = 0;
  CP_record_similarity_input_fn[0] = 0;
  CP_record_similarity_class[0] = 0;
  
  CP_write_DT_names_file = FALSE;
  CP_write_DT_names_fn[0] = 0;

  AP_epoch_length = 200;
  OP_rg_rows = 8;
  OP_rg_cols = 15;
  OP_rg_vals = 6;
  AP_record_opponent_positions = FALSE;
  AP_record_ball_position = FALSE;
  AP_record_ball_controller = FALSE;
  AP_record_passing_rects = FALSE;
  AP_record_dribble_rects = FALSE;
  AP_record_shot_rects = FALSE;
  AP_record_action_count = FALSE;
  AP_record_player_proximity = FALSE;
  
  OP_pass_timeout = 50;
  OP_min_pass_dist = 5.655; /* kickable_area (v4.xx) * 3 */
  OP_pass_num_past_cont = 2;

  OP_drib_num_past_cont = 5;
  OP_max_drib_cntl_intvl = 5;
  OP_min_drib_dist = 3.0;

  OP_shot_num_past_cont = 2;
  OP_shot_cntl_timeout = 1;
  OP_shot_goal_buf = 5;

  OP_opp_pos_match_var = 1; 

  CP_classify_adversary = TRUE; 


#include<opt-def.C>
}

void OptionInfo::GetOptions(int argc, char **argv)
{
  option_t opt[] = {

    {"alarm_interval",          (void *)&CP_alarm_interval,         V_INT},
    {"max_cycles_since_io",     (void *)&CP_max_cycles_since_io,      V_INT},
    
    {"just_observe",            (void *)&CP_just_observe,           V_ONOFF},
    {"analyze_log",             (void *)&CP_analyze_log,            V_ONOFF},
    {"log_fn",                  (void *)&CP_log_fn,                 V_STRING},

    {"output_directory",        (void *)&CP_output_directory,       V_STRING},
    {"side_to_analyze",         (void *)&CP_side_to_analyze,        V_STRING},
    {"team_to_analyze",         (void *)&CP_team_to_analyze,        V_STRING},
    
    {"coach_setplays",          (void *)&CP_coach_setplays,         V_ONOFF},
    {"team_name",               (void *)&CP_team_name,              V_STRING},

    {"take_stats",              (void *)&CP_take_stats,             V_ONOFF},
    {"record_detail_stats",     (void *)&CP_record_detail_stats,    V_ONOFF},
    {"record_summary_stats",    (void *)&CP_record_summary_stats,   V_ONOFF},
    {"classify_adversary",      (void *)&CP_classify_adversary,     V_ONOFF},
    
    {"control_buffer",              (void *)&CP_control_buffer, V_FLOAT},

    {"show_progress",               (void *)&CP_show_progress, V_ONOFF},
    
    {"create_adv_class",            (void *)&CP_create_adv_class, V_BOOL},
    {"create_random_adv_class",     (void *)&CP_create_random_adv_class, V_BOOL},
    {"create_adv_class_list_fn",    (void *)&CP_create_adv_class_list_fn, V_STRING},
    {"create_adv_class_name",       (void *)&CP_create_adv_class_name, V_STRING},
    {"create_adv_class_out_fn",     (void *)&CP_create_adv_class_out_fn, V_STRING},
    {"create_adv_class_calc_int_sim",(void *)&CP_create_adv_class_calc_int_sim, V_ONOFF},

    {"record_similarity",           (void *)&CP_record_similarity,           V_ONOFF},
    {"record_adv_class_similarity", (void *)&CP_record_adv_class_similarity, V_ONOFF},
    {"record_similarity_output_fn", (void *)&CP_record_similarity_output_fn, V_STRING},
    {"record_similarity_input_fn",  (void *)&CP_record_similarity_input_fn,  V_STRING},
    {"record_similarity_class",     (void *)&CP_record_similarity_class,     V_STRING},
    
    {"write_DT_names_file",        (void *)&CP_write_DT_names_file,        V_ONOFF},
    {"write_DT_names_fn",          (void *)&CP_write_DT_names_fn,          V_STRING},

    {"adversary_class_list_fn",     (void *)&CP_adversary_class_list_fn,  V_STRING},
    {"epoch_length",                (void *)&AP_epoch_length, V_INT},
    {"rg_rows",                     (void *)&OP_rg_rows, V_INT},
    {"rg_cols",                     (void *)&OP_rg_cols, V_INT},
    {"rg_vals",                     (void *)&OP_rg_vals, V_INT},

    {"record_opponent_positions",   (void *)&AP_record_opponent_positions, V_ONOFF},
    {"record_ball_position",        (void *)&AP_record_ball_position, V_ONOFF},
    {"record_ball_controller",      (void *)&AP_record_ball_controller, V_ONOFF},
    {"record_passing_rects",        (void *)&AP_record_passing_rects, V_ONOFF},
    {"record_dribble_rects",        (void *)&AP_record_dribble_rects, V_ONOFF},
    {"record_shot_rects",           (void *)&AP_record_shot_rects,    V_ONOFF},
    {"record_action_count",         (void *)&AP_record_action_count,  V_ONOFF},
    {"record_player_proximity",     (void *)&AP_record_player_proximity,  V_ONOFF},
		
    {"pass_timeout",                (void *)&OP_pass_timeout, V_INT},
    {"min_pass_dist",               (void *)&OP_min_pass_dist, V_FLOAT},
    {"pass_num_past_cont",          (void *)&OP_pass_num_past_cont, V_INT},

    {"drib_num_past_cont",          (void *)&OP_drib_num_past_cont, V_INT},
    {"max_drib_cntl_intvl",         (void *)&OP_max_drib_cntl_intvl, V_INT},
    {"min_drib_dist",               (void *)&OP_min_drib_dist, V_FLOAT},

    {"shot_num_past_cont",          (void *)&OP_shot_num_past_cont, V_INT},
    {"shot_cntl_timeout",           (void *)&OP_shot_cntl_timeout, V_INT},
    {"shot_goal_buf",               (void *)&OP_shot_goal_buf, V_FLOAT},

    {"opp_pos_match_var",           (void *)&OP_opp_pos_match_var, V_INT},

    
#include<opt-array.C>	
    {"\0",				NULL, 			       	0}
  } ;

#include<opt-code.C>
  
}



