#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#if defined(WIN32)
#include <fcntl.h>
#include <io.h>
#else
#include <unistd.h>
#include <sys/file.h>
#endif

/* Just in case O_BINARY isn't defined. */
#if !defined(O_BINARY)
#define O_BINARY 0
#endif

/* Macro to byteswap an int variable.  x = ptr to variable */
#define SWAP_INT(x)   *(x) = ((0x000000ff & (*(x))>>24) | \
                                (0x0000ff00 & (*(x))>>8) | \
                                (0x00ff0000 & (*(x))<<8) | \
                                (0xff000000 & (*(x))<<24))
/* Macro to byteswap a float variable.  x = ptr to variable */
#define SWAP_FLOAT(x) SWAP_INT((int *) x)


int write_cep(char *cepfilename, float **cep, int nframes, int numcep)
{
	int fcep, i;
	int length, wrbytes;
	float *X;

	X = cep[0];

	if ((fcep =
	     open(cepfilename, O_CREAT | O_WRONLY | O_TRUNC | O_BINARY,
		  0644)) < 0) {
		printf("Unable to open %s for writing\n", cepfilename);
		return (-1);
	}

	length = nframes * numcep;
	SWAP_INT(&length);
	if (write(fcep, &length, 4) != 4) {
		printf("Data write error on %s\n", cepfilename);
		close(fcep);
		return (-1);
	}
	SWAP_INT(&length);

	for (i = 0; i < length; ++i)
		SWAP_FLOAT(cep[0] + i);
	wrbytes = length * sizeof(float);
	if (write(fcep, cep[0], wrbytes) != wrbytes) {
		printf("Data write error on %s\n", cepfilename);
		close(fcep);
		return (-1);
	}
	for (i = 0; i < length; ++i)
		SWAP_FLOAT(cep[0] + i);
	close(fcep);
	printf("Wrote %d cepstral vectors of length %d in %s\n",
	       nframes, numcep, cepfilename);
	return (length);
}
