#!/bin/sh
# The VTS program estimates the parameters of a linear filter and additive
# noise from  sequences of log spectral vectors and compensates the vectors
# for them. The distribution of clean speech (as computed by VTS_dist) are
# needed for this purpose.
# The compensated logspectra are converted to 13-dim cepstra before being
# written out.
# The binary is called in the following manner
#./$arch/VTS -c <control file> \
#        -i <path of incoming noisy logspec files> \
#        -o <path to write compensated mfc files> \
#        -x <extension of input logspec file names (default: 'mfc')> \
#        -y <extension to use on compensated mfc files (default: 'vps.mfc'> \
#        -d <file with VTS distribution to use>
# The control file is simply a list of the files that are to be compensated.
# Pathnames can be relative in the control file, since the global path to
# the input can be passed using the "-i" argument.
# The directory structure in which compensated files are written out is
# assumed to be identical to that of the incoming noisy files.
# The logspectral vectors are assumed to have the same dimension as the
# VTS distribution being used (so it is necessary that the distribution be
# computed using logspectral vectors of the same dimension as the noisy
# speech logspectral vectors.


basedir=./test
bindir=./$MACHINE
ctlfile=$basedir/an4.microtest.ctl
VTSdist=../estimate_mixgau/test/an4.64.VTS.dist
inpath=$basedir/data
outpath=$basedir
infileext=logspec
outfileext=mfc
logfile=$basedir/vts.log


$bindir/VTS -c $ctlfile \
        -i $inpath \
        -o $outpath \
        -x $infileext \
        -y $outfileext \
        -d $VTSdist > $logfile 2>&1
