/*------------------------------------------------------------------------------
	Function defining the log gaussian density function given mean and 
        variance.
------------------------------------------------------------------------------*/
#include <math.h>

float gauss(float *x,
	    float *mean, float *var_inverse, float corprod; int Ndim) {
	auto int j;
	auto float power = 0, density;

	for (j = 0; j < Ndim; ++j)
		power +=
		    (x[j] - mean[j]) * (x[j] - mean[j]) * var_inverse[j];
	power *= -0.5;
	density = corprod + power;
	return (density);
}
