#include <math.h>

void compute_wts(float **mean,
		 float **var,
		 int nmodes,
		 int ndim,
		 float *n,
		 float *h,
		 float **wta,
		 float **wtb, float **wtaa, float **wtab, float **wtbb)
{
	int i, j;

	for (i = 0; i < nmodes; ++i) {
		for (j = 0; j < ndim; ++j) {
			wta[i][j] =
			    1.0 / (1.0 + exp(n[j] - h[j] - mean[i][j]));
			wtb[i][j] = 1.0 - wta[i][j];
			wtaa[i][j] = wta[i][j] * wta[i][j];
			wtab[i][j] = wta[i][j] * wtb[i][j];
			wtbb[i][j] = wtb[i][j] * wtb[i][j];
		}
	}
	return;
}
