#include <math.h>

void compute_mwts(float **mean,
		  float **var,
		  int nmodes,
		  int ndim, float *n, float *q, float **wta, float **wtb)
{
	int i, j;

	for (i = 0; i < nmodes; ++i) {
		for (j = 0; j < ndim; ++j) {
			wta[i][j] =
			    1.0 / (1.0 + exp(n[j] - q[j] - mean[i][j]));
			wtb[i][j] = 1.0 - wta[i][j];
		}
	}
	return;
}
