/*-----------------------------------------------------------------------------
    One of the terms in the expansion of z
    z = x + q + ln(1+exp(n-q-x)) = n + ln(1+exp(x-n-q))
    z = a(x+q+r()) + (1-a)(n+s())
    z = a(x+q) + (1-a)n + f()
      where f() = a.r() + (1-a).s()
------------------------------------------------------------------------------*/
#include <math.h>

void compute_f(float *n,
	       float *q,
	       float **xmean,
	       float **f, float **wta, float **wtb, int nmodes, int ndim)
{
	int i, j;
	float E, sum, r0, r1;

	for (i = 0; i < nmodes; ++i) {
		for (j = 0; j < ndim; ++j) {
			sum = n[j] - q[j] - xmean[i][j];
			E = exp(sum);
			r0 = log(1 + E);
			r1 = log(1 + 1 / E);
			f[i][j] = wta[i][j] * r0 + wtb[i][j] * r1;
		}
	}
	return;
}
