/*----------------------------------------------------------------------------
     Routine to allocate various parameters used by the q/n estimator of
     VTS-order1. 
     It uses alloc2d() to allocate two dimensional arrays, and malloc()
     to allocate 1d arrays.
     In case of failure of allocation echoes a warning and returns error.
------------------------------------------------------------------------------*/
#include <stdlib.h>
//#include "malloc.h"
#include <stdio.h>

#include "VTS.h"

int allocate(float ***f, float ***wta, float ***wtb, float ***wtaa, float ***wtab, float ***wtbb, float ***zmean, float ***zvar, float **zcorprod,	/* The parameters of z */
	     float **pk, float **A, float **B, float **C, float **D, float **E, float **F, float **G,	/* More simplifying terms */
	     int nmodes, int ndim	/* Number of modes in distribution and dimensionality */
    )
{
	float *Abuff, *Bbuff, *Cbuff, *Dbuff, *Ebuff, *Fbuff;
	float *Gbuff, *pkbuff, *zcorprodbuff;
	float **fbuff = NULL, **wtabuff = NULL, **wtbbuff = NULL;
	float **wtbbbuff = NULL, **wtabbuff = NULL, **wtaabuff = NULL;
	float **zmeanbuff = NULL, **zvarbuff = NULL;
	int NOERROR = 1;

	if ((Abuff = (float *) malloc(ndim * sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer A[]\n"));
		NOERROR = 0;
	} else {
		*A = Abuff;
		NOERROR = 1;
	}

	if ((Bbuff = (float *) malloc(ndim * sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer B[]\n"));
		NOERROR = 0;
	} else {
		*B = Bbuff;
		NOERROR = 1;
	}

	if ((Cbuff = (float *) malloc(ndim * sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer C[]\n"));
		NOERROR = 0;
	} else {
		*C = Cbuff;
		NOERROR = 1;
	}

	if ((Dbuff = (float *) malloc(ndim * sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer D[]\n"));
		NOERROR = 0;
	} else {
		*D = Dbuff;
		NOERROR = 1;
	}

	if ((Ebuff = (float *) malloc(ndim * sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer E[]\n"));
		NOERROR = 0;
	} else {
		*E = Ebuff;
		NOERROR = 1;
	}

	if ((Fbuff = (float *) malloc(ndim * sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer F[]\n"));
		NOERROR = 0;
	} else {
		*F = Fbuff;
		NOERROR = 1;
	}

	if ((Gbuff = (float *) malloc(ndim * sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer G[]\n"));
		NOERROR = 0;
	} else {
		*G = Gbuff;
		NOERROR = 1;
	}

	if ((pkbuff = (float *) malloc(nmodes * sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer pk[]\n"));
		NOERROR = 0;
	} else {
		*pk = pkbuff;
		NOERROR = 1;
	}

	if ((zcorprodbuff =
	     (float *) malloc(nmodes * sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer zcorprod[]\n"));
		NOERROR = 0;
	} else {
		*zcorprod = zcorprodbuff;
		NOERROR = 1;
	}

	if ((fbuff =
	     (float **) alloc2d(nmodes, ndim, sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer f[][]\n"));
		NOERROR = 0;
	} else {
		*f = fbuff;
		NOERROR = 1;
	}

	if ((zmeanbuff =
	     (float **) alloc2d(nmodes, ndim, sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer zmean[][]\n"));
		NOERROR = 0;
	} else {
		*zmean = zmeanbuff;
		NOERROR = 1;
	}

	if ((zvarbuff =
	     (float **) alloc2d(nmodes, ndim, sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer zvar[][]\n"));
		NOERROR = 0;
	} else {
		*zvar = zvarbuff;
		NOERROR = 1;
	}

	if ((wtabuff =
	     (float **) alloc2d(nmodes, ndim, sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer wta[][]\n"));
		NOERROR = 0;
	} else {
		*wta = wtabuff;
		NOERROR = 1;
	}

	if ((wtbbuff =
	     (float **) alloc2d(nmodes, ndim, sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer wtb[][]\n"));
		NOERROR = 0;
	} else {
		*wtb = wtbbuff;
		NOERROR = 1;
	}

	if ((wtaabuff =
	     (float **) alloc2d(nmodes, ndim, sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer wtaa[][]\n"));
		NOERROR = 0;
	} else {
		*wtaa = wtaabuff;
		NOERROR = 1;
	}
	if ((wtabbuff =
	     (float **) alloc2d(nmodes, ndim, sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer wtab[][]\n"));
		NOERROR = 0;
	} else {
		*wtab = wtabbuff;
		NOERROR = 1;
	}
	if ((wtbbbuff =
	     (float **) alloc2d(nmodes, ndim, sizeof(float))) == NULL) {
		WARNING(("Unable to allocate space for buffer wtbb[][]\n"));
		NOERROR = 0;
	} else {
		*wtbb = wtbbbuff;
		NOERROR = 1;
	}

	return (NOERROR);
}
