#define  WARNING(X)     {printf("**ACHTUNG!**");printf X;fflush(stdout);}
#define  SIGNIFICANT    0.001f
#define  FAILURE        0
#define  UNSURE         0
#define  SUCCESS	1
#define  CEPDIM         13

#define  SPEECH_THRESHOLD 1.2f

#define  MIN_NOISE_VAR  0.25f
#define  MAX_NOISE_VAR  50.0f

#define DESCRIPTION "\nProgram to compensate speech logspectra files for the effect of noise and channel\nPerforms normalization on a bunch of noisy files given clean speech statistics\n(VTS style statistics). The routine reads the noisy files from the input path\nand dumps the compensated cesptral files in the output path. The control files should\nNOT contain file extensions.\nNOTE: The program assumes that the dimension of the VTS statistics and the\n   data are the same. If your log spectral files and the distribution have \n   different dimensionality the program will die a horrible death!!\n"

#define  USAGE "\nUSAGE:\n%s -c <control file> \\\n\t-i <path of noisy logspec files> \\\n\t-o <path where to place compensated mfc files> \\\n\t-x <extension of input logspec file names (default: 'mfc')> \\\n\t-y <extension to use on compensated mfc files (default: 'vps.mfc'> \\\n\t-d <file with VPS distribution to use>\n"

int readdistribution(char *filename, float ***mean, float ***vars,
		     float **prob, int *ncodes, int *Ndim);

float **logspec2cep(float **logspec, int numvectors, int Nfilters,
		    int cepdim);

char **alloc2d(int dim1, int dim2, int size);

void free2d(void **p);

int allocate(float ***f, float ***wta, float ***wtb, float ***wtaa, 
	     float ***wtab, float ***wtbb, float ***zmean, 
	     float ***zvar, float **zcorprod, float **pk, 
	     float **A, float **B, float **C, float **D, float **E, 
	     float **F, float **G, int nmodes, int ndim);

void free_all(float **w,
	      float **x,
	      float **y,
	      float **xx,
	      float **xy,
	      float **yy,
	      float **z,
	      float **zv,
	      float *zc,
	      float *pk,
	      float *A,
	      float *B, float *C, float *D, float *E, float *F, float *G);

int mmsealloc(float ***f, float ***wta, float ***wtb, float ***zmean, 
	      float ***zvar, float **zcorprod, float **pk, int nmodes,
	      int ndim);

void mmsefree_all(float **w, float **x, float **y, 
		  float **z, float **zv, float *zc, float *pk);

int areadfloat(char *file, float **buff, int *numfloats);

int write_cep(char *cepfilename, float **cep, int nframes, int numcep);

float **two_D_ize(float *buff, int length, int dim);

int mmse(float **x,
	 float **z,
	 float *prior,
	 float **mean,
	 float **var,
	 float *nmean,
	 float *nvar, float *q, int nframes, int nmodes, int ndim);

void initialize(float *chan,
		float *nmean,
		float *nvar,
		float **xmean,
		float **xvar,
		float *prob,
		float **z, int n_frames, int n_modes, int ndim);

int estimate(float **z,
	     float *prior,
	     float **xmean,
	     float **xvar,
	     float *nvar, float *q, float *n, int nz, int nmodes, int ndim);

float expectation(float *Tau, float *x, float **mean, 
		  float **var_inverse, float *corprod, int K, int Ndim);

int compute_params(float *n, float *q, float *n_var, float *A, 
		   float *B, float *C, float *D, float *E, float *F, 
		   float *G, float **wta, float **wtb, float **xvar, 
		   int nmodes, int ndim);

void compute_f(float *n,
	       float *q,
	       float **xmean,
	       float **f, float **wta, float **wtb, int nmodes, int ndim);

void compute_mwts(float **mean,
		  float **var,
		  int nmodes,
		  int ndim, float *n, float *q, float **wta, float **wtb);

void compute_wts(float **mean,
		 float **var,
		 int nmodes,
		 int ndim,
		 float *n,
		 float *h,
		 float **wta,
		 float **wtb, float **wtaa, float **wtab, float **wtbb);

void compute_zstats(float **zmean,
		    float **zvar_inv,
		    float *zcorprod,
		    float **wta,
		    float **wtb,
		    float **f,
		    float **xmean,
		    float **xvar,
		    float *xprior,
		    float *n, float *q, float *n_var, int nmodes, int ndim);
