#!/bin/sh
#
# The executable from this directory computes a distribution for use with VTS
# The distribution computed is a Gaussian mixture, where one of the
# Gaussians is used to model the distribution of silence regions of speech.
#
# This script uses the VTS_stats binary to compute the Gaussian mixture.
# The routine works in 5 super iterations of 3 EM iterations each. After each
# of the superiterations the complete distribution is dumped. After each EM
# iteration partial results are dumped in the tempfile, which can be used to
# recover in case of a crash.
#
# The command has the following structure:
#$MACHINE/VTS_stats -e $ext \
#        -c $ctlfile \
#        -o $outfile \
#        -n $nmodes \
#        -d $dim \
#        -t $tempfile
#
# ext = filename extension of the logspectral files. This argument is optional,
#           depending on the $ctlfile
#
# ctlfile = control file holding the names of all the files 
#           The filenames listed may or may not have the extension (i.e
#           either "file.mfc" or "file"). If the extension is not given
#           the -e $ext option has to be used to specify the extension. Note
#           that if the -e argument is used, it is assumed that the ctlfile
#           does not contain file extensions. If the file names do include the
#           extension DO NOT use the -e argument.
#	    The control file has the following format:
#$fullpath/$uttname1
#$fullpath/$uttname2
#..
#(without the "#"es of course)
#                
# outfile = File to write distribution to. Stored in ASCII format.
#
# nmodes = Number of gaussians required in the distribution to be computed.
#           This has to be specified (there is no default)
#
# dim = Dimensionality of the logspectral vector. The default is 40 (if the 
#             -d argument is not used a dimensionality of 40 is assumed)
#
# tempfile = The routine dumps partial results in this file to recover from
#            in case of a crash. For details looks at the scripts 
#            VTS_recover.csh
#
#INPUT DATA FORMAT: 
#   All input logspectral files are assumed to be binary files with the 
#   following format:
#   <4 byte int header><4 byte float><4 byte float>....
#   The integer header gives the number of floating point numbers to
#   follow in the file.
#   The floating point numbers are the logspectral values written
#   sequentially.
#   So a sequence of 4 logspectral vectors, each of four dimensions would
#   be stored as:
#   <16><l[0][0]><l[0][1]><l[0][2]><l[0][3]><l[1][0]>....<l[3][3]>
#

basedir=./test
bindir=./$MACHINE

ctldir=$basedir/ctldir
distdir=$basedir/distributions
logdir=$basedir/log
tmpdir=$basedir/tmp

ext=logspec
dim=40
nmodes=64
ctlfile=$basedir/an4.microtrain.ctl
outfile=$basedir/an4.$nmodes.VTS.dist
logfile=$basedir/an4.$nmodes.VTS.log
tempfile=$basedir/VTS.temp

$bindir/estim_mixgau   -e $ext \
                       -d $dim \
                       -c $ctlfile \
                       -o $outfile \
                       -m $nmodes  \
                       -t $tempfile \
         > $logfile 2>&1
