#!/bin/csh
#
# Script to compute distribution for use with CDCN. This distribution is 
# guaranteed to give better results than generic distributions though those
# work very well too..
#
# ext = filename extension of the cepstral files
# ctlfile = control file holding the names of all the files 
#                    (with path,minus extension), to compute distribution on.
# maxvecs = Maximum number of vectors expected in all the data set.
# outfile = File to write distribution to
# nmodes = Number of modes needed in the distribution
# noisewidth = The width of c0 to use to compute the separate noise mode

set basedir = ~/algorithms/src/RATS
set ctldir = $basedir/ctldir
set distdir = $basedir/distributions
set bindir = $basedir/cdcn_distribution/$arch
set logdir = $basedir/log

set ext = mfc

set maxvecs = 2700000
set nmodes = 256
set noisewidth = 1.0

foreach set ( "m-1" )
	set ctlfile = $ctldir/atis-"$set".ctl-real
	set outfile = $distdir/ATIS.$nmodes.cdcn.$set.dist
	set logfile = $logdir/ATIS.cdcndist.$nmodes.$set.log

	$bindir/cdcn_stats     -e  $ext \
                       -c $ctlfile \
                       -o $outfile \
                       -l $maxvecs \
                       -n $nmodes  \
                       -w $noisewidth \
         >& $logfile

end


set maxvecs = 3300000

foreach set ( "m-2" )
	set ctlfile = $ctldir/atis-"$set".ctl-real
	set outfile = $distdir/ATIS.$nmodes.cdcn.$set.dist
	set logfile = $logdir/ATIS.cdcndist.$nmodes.$set.log

	$bindir/cdcn_stats     -e  $ext \
                       -c $ctlfile \
                       -o $outfile \
                       -l $maxvecs \
                       -n $nmodes  \
                       -w $noisewidth \
         >& $logfile

end



