#include <stdio.h>
#include <stdlib.h>

#include "header.h"

int read_backup_distribution(char *filen,
			     float ***mean,
			     float ***variance,
			     float **pi, int *Nmodes, int Ndim)
{
	int j, k, imodes, idim;
	float **varbuff, **meanbuff, *cbuff;

	FILE *dist;

	if ((dist = fopen(filen, "r")) == NULL) {
		printf("Unable to open distribution file\n");
		return (0);
	}

	fscanf(dist, "%d %d", &imodes, &idim);

	*Nmodes = imodes;

	if (idim != Ndim) {
		printf("ERROR in read_distribution:\n");
		printf
		    ("Distribution dimensionality != Dimensionality of data given\n");
		return (0);
	}

	if ((varbuff =
	     (float **) alloc2d(imodes, idim, sizeof(float))) == NULL) {
		printf("Unable to allocate space for variances\n");
		return (0);
	}

	if ((meanbuff =
	     (float **) alloc2d(imodes, idim, sizeof(float))) == NULL) {
		printf("Unable to allocate space for means\n");
		return (0);
	}

	if ((cbuff = (float *) malloc(imodes * sizeof(float))) == NULL) {
		printf("Unable to allocate space for priors\n");
		return (0);
	}

	for (k = 0; k < imodes; ++k) {
		fscanf(dist, "%f", &cbuff[k]);
		for (j = 0; j < idim; ++j)
			fscanf(dist, "%f ", &meanbuff[k][j]);
		for (j = 0; j < idim; ++j)
			fscanf(dist, "%f ", &varbuff[k][j]);
	}
	fclose(dist);

	*variance = varbuff;
	*mean = meanbuff;
	*pi = cbuff;

	return (1);
}
